/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LogMessage;
import com.zeroc.Ice.LogMessageType;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.RemoteLoggerPrx;
import com.zeroc.Ice.UnknownException;
import com.zeroc.IceInternal.LoggerAdminI;
import com.zeroc.IceInternal.LoggerAdminLogger;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Deque;
import java.util.List;

final class LoggerAdminLoggerI
implements LoggerAdminLogger,
Runnable {
    private final Logger _localLogger;
    private final LoggerAdminI _loggerAdmin;
    private boolean _destroyed = false;
    private Thread _sendLogThread;
    private final Deque<Job> _jobQueue = new ArrayDeque<Job>();

    @Override
    public void print(String message) {
        LogMessage logMessage = new LogMessage(LogMessageType.PrintMessage, LoggerAdminLoggerI.now(), "", message);
        this._localLogger.print(message);
        this.log(logMessage);
    }

    @Override
    public void trace(String category, String message) {
        LogMessage logMessage = new LogMessage(LogMessageType.TraceMessage, LoggerAdminLoggerI.now(), category, message);
        this._localLogger.trace(category, message);
        this.log(logMessage);
    }

    @Override
    public void warning(String message) {
        LogMessage logMessage = new LogMessage(LogMessageType.WarningMessage, LoggerAdminLoggerI.now(), "", message);
        this._localLogger.warning(message);
        this.log(logMessage);
    }

    @Override
    public void error(String message) {
        LogMessage logMessage = new LogMessage(LogMessageType.ErrorMessage, LoggerAdminLoggerI.now(), "", message);
        this._localLogger.error(message);
        this.log(logMessage);
    }

    @Override
    public String getPrefix() {
        return this._localLogger.getPrefix();
    }

    @Override
    public Logger cloneWithPrefix(String prefix) {
        return this._localLogger.cloneWithPrefix(prefix);
    }

    @Override
    public Object getFacet() {
        return this._loggerAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Thread thread = null;
        LoggerAdminLoggerI loggerAdminLoggerI = this;
        synchronized (loggerAdminLoggerI) {
            if (this._sendLogThread != null) {
                thread = this._sendLogThread;
                this._sendLogThread = null;
                this._destroyed = true;
                this.notifyAll();
            }
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LoggerAdminLoggerI loggerAdminLoggerI2 = this;
                synchronized (loggerAdminLoggerI2) {
                    this._sendLogThread = thread;
                }
                throw new OperationInterruptedException();
            }
        }
        this._loggerAdmin.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._loggerAdmin.getTraceLevel() > 1) {
            this._localLogger.trace("Admin.Logger", "send log thread started");
        }
        block7: while (true) {
            Job job = null;
            java.lang.Object object = this;
            synchronized (object) {
                while (!this._destroyed && this._jobQueue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this._destroyed) {
                    break;
                }
                assert (!this._jobQueue.isEmpty());
                job = this._jobQueue.removeFirst();
            }
            object = job.remoteLoggers.iterator();
            while (true) {
                if (!object.hasNext()) continue block7;
                RemoteLoggerPrx p = (RemoteLoggerPrx)object.next();
                if (this._loggerAdmin.getTraceLevel() > 1) {
                    this._localLogger.trace("Admin.Logger", "sending log message to `" + p.toString() + "'");
                }
                try {
                    p.logAsync(job.logMessage).whenComplete((v, ex) -> {
                        if (ex != null) {
                            if (!(ex instanceof CommunicatorDestroyedException)) {
                                if (ex instanceof LocalException) {
                                    this._loggerAdmin.deadRemoteLogger(p, this._localLogger, (LocalException)ex, "log");
                                } else {
                                    this._loggerAdmin.deadRemoteLogger(p, this._localLogger, new UnknownException((Throwable)ex), "log");
                                }
                            }
                        } else if (this._loggerAdmin.getTraceLevel() > 1) {
                            this._localLogger.trace("Admin.Logger", "log on `" + p.toString() + "' completed successfully");
                        }
                    });
                }
                catch (LocalException ex2) {
                    this._loggerAdmin.deadRemoteLogger(p, this._localLogger, ex2, "log");
                }
            }
            break;
        }
        if (this._loggerAdmin.getTraceLevel() > 1) {
            this._localLogger.trace("Admin.Logger", "send log thread completed");
        }
    }

    LoggerAdminLoggerI(Properties props, Logger localLogger) {
        this._localLogger = localLogger instanceof LoggerAdminLoggerI ? ((LoggerAdminLoggerI)localLogger).getLocalLogger() : localLogger;
        this._loggerAdmin = new LoggerAdminI(props, this);
    }

    Logger getLocalLogger() {
        return this._localLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(LogMessage logMessage) {
        List<RemoteLoggerPrx> remoteLoggers = this._loggerAdmin.log(logMessage);
        if (remoteLoggers != null) {
            assert (!remoteLoggers.isEmpty());
            LoggerAdminLoggerI loggerAdminLoggerI = this;
            synchronized (loggerAdminLoggerI) {
                if (this._sendLogThread == null) {
                    this._sendLogThread = new Thread((Runnable)this, "Ice.SendLogThread");
                    this._sendLogThread.start();
                }
                this._jobQueue.addLast(new Job(remoteLoggers, logMessage));
                this.notifyAll();
            }
        }
    }

    private static long now() {
        return Calendar.getInstance().getTimeInMillis() * 1000L;
    }

    private static class Job {
        final List<RemoteLoggerPrx> remoteLoggers;
        final LogMessage logMessage;

        Job(List<RemoteLoggerPrx> r, LogMessage l) {
            this.remoteLoggers = r;
            this.logMessage = l;
        }
    }
}

