/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceBox;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.SliceChecksumDictHelper;
import com.zeroc.Ice.UserException;
import com.zeroc.IceBox.AlreadyStartedException;
import com.zeroc.IceBox.AlreadyStoppedException;
import com.zeroc.IceBox.NoSuchServiceException;
import com.zeroc.IceBox.ServiceObserverPrx;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface ServiceManager
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public Map<String, String> getSliceChecksums(Current var1);

    public void startService(String var1, Current var2) throws AlreadyStartedException, NoSuchServiceException;

    public void stopService(String var1, Current var2) throws AlreadyStoppedException, NoSuchServiceException;

    public void addObserver(ServiceObserverPrx var1, Current var2);

    public void shutdown(Current var1);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return ServiceManager.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceBox::ServiceManager";
    }

    public static CompletionStage<OutputStream> _iceD_getSliceChecksums(ServiceManager obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        Map<String, String> ret = obj.getSliceChecksums(current);
        OutputStream ostr = inS.startWriteParams();
        SliceChecksumDictHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_startService(ServiceManager obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_service = istr.readString();
        inS.endReadParams();
        obj.startService(iceP_service, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_stopService(ServiceManager obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_service = istr.readString();
        inS.endReadParams();
        obj.stopService(iceP_service, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_addObserver(ServiceManager obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ServiceObserverPrx iceP_observer = ServiceObserverPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        obj.addObserver(iceP_observer, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_shutdown(ServiceManager obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.shutdown(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return ServiceManager._iceD_addObserver(this, in, current);
            }
            case 1: {
                return ServiceManager._iceD_getSliceChecksums(this, in, current);
            }
            case 2: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 5: {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 6: {
                return ServiceManager._iceD_shutdown(this, in, current);
            }
            case 7: {
                return ServiceManager._iceD_startService(this, in, current);
            }
            case 8: {
                return ServiceManager._iceD_stopService(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceBox::ServiceManager"};
        _iceOps = new String[]{"addObserver", "getSliceChecksums", "ice_id", "ice_ids", "ice_isA", "ice_ping", "shutdown", "startService", "stopService"};
    }
}

