/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.mvel2.ConversionHandler;

public class ListCH
implements ConversionHandler {
    @Override
    public Object convertFrom(Object in) {
        Class<?> type2 = in.getClass();
        ArrayList<Object> newList = new ArrayList<Object>();
        if (type2.isArray()) {
            newList.addAll(Arrays.asList((Object[])in));
        } else if (Collection.class.isAssignableFrom(type2)) {
            newList.addAll((Collection)in);
        } else if (Iterable.class.isAssignableFrom(type2)) {
            for (Object o : (Iterable)in) {
                newList.add(o);
            }
        }
        return newList;
    }

    @Override
    public boolean canConvertFrom(Class cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls) || Iterable.class.isAssignableFrom(cls);
    }
}

