/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\u0010\b\u001a\u00060\tR\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\tR\u00020\nH\u0014J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0010\u001a\u00060\tR\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\r2\n\u0010\u0010\u001a\u00060\tR\u00020\nH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/HtmlBlockMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "endCheckingRegex", "Lkotlin/text/Regex;", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Lkotlin/text/Regex;Lorg/intellij/markdown/parser/LookaheadText$Position;)V", "allowsSubBlocks", "", "calcNextInterestingOffset", "", "pos", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "markdown"})
public final class HtmlBlockMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final ProductionHolder productionHolder;
    @Nullable
    private final Regex endCheckingRegex;

    public HtmlBlockMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @Nullable Regex endCheckingRegex, @NotNull LookaheadText.Position startPosition) {
        Intrinsics.checkNotNullParameter(myConstraints, "myConstraints");
        Intrinsics.checkNotNullParameter(productionHolder, "productionHolder");
        Intrinsics.checkNotNullParameter(startPosition, "startPosition");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.endCheckingRegex = endCheckingRegex;
        this.productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(new IntRange(startPosition.getOffset(), startPosition.getNextLineOrEofOffset()), MarkdownTokenTypes.HTML_BLOCK_CONTENT)));
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return true;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(currentConstraints, "currentConstraints");
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        String string = pos.getPrevLine();
        if (string == null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        String prevLine = string;
        if (!MarkdownConstraintsKt.extendsPrev(this.getConstraints().applyToNextLine(pos), this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        if (this.endCheckingRegex == null && MarkdownParserUtil.INSTANCE.calcNumberOfConsequentEols(pos, this.getConstraints()) >= 2) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        if (this.endCheckingRegex != null && Regex.find$default(this.endCheckingRegex, prevLine, 0, 2, null) != null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        if (((CharSequence)pos.getCurrentLine()).length() > 0) {
            this.productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(new IntRange(pos.getOffset() + 1 + MarkdownConstraintsKt.getCharsEaten(this.getConstraints(), pos.getCurrentLine()), pos.getNextLineOrEofOffset()), MarkdownTokenTypes.HTML_BLOCK_CONTENT)));
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.HTML_BLOCK;
    }
}

