"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = __importDefault(require("assert"));
const indentFolding_1 = require("../../src/lib/foldingRange/indentFolding");
describe('indent based folding', () => {
    it('can guess tab size', () => {
        assert_1.default.deepStrictEqual((0, indentFolding_1.guessTabSize)([
            { spaceCount: 2, tabCount: 1 },
            { spaceCount: 4, tabCount: 1 },
            { spaceCount: 6, tabCount: 1 }
        ]), 2);
        assert_1.default.deepStrictEqual((0, indentFolding_1.guessTabSize)([
            { spaceCount: 4, tabCount: 1 },
            { spaceCount: 8, tabCount: 1 },
            { spaceCount: 12, tabCount: 1 }
        ]), 4);
    });
    it('can guess tab size with inconsistent mix of tab and space', () => {
        assert_1.default.deepStrictEqual((0, indentFolding_1.guessTabSize)([
            { spaceCount: 0, tabCount: 1 },
            { spaceCount: 2, tabCount: 1 },
            { spaceCount: 6, tabCount: 0 },
            { spaceCount: 4, tabCount: 1 }
        ]), 2);
        assert_1.default.deepStrictEqual((0, indentFolding_1.guessTabSize)([
            { spaceCount: 0, tabCount: 1 },
            { spaceCount: 4, tabCount: 0 },
            { spaceCount: 6, tabCount: 0 },
            { spaceCount: 4, tabCount: 1 }
        ]), 2);
        assert_1.default.deepStrictEqual((0, indentFolding_1.guessTabSize)([
            { spaceCount: 0, tabCount: 2 },
            { spaceCount: 4, tabCount: 0 },
            { spaceCount: 4, tabCount: 1 }
        ]), 2);
    });
});
//# sourceMappingURL=indentFolding.test.js.map