# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
This is a wrapper for The CD Input and Control library's ISO-9660 library
See also the ISO-9660 specification. The freely available European
equivalant standard is called ECMA-119.
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _pyiso9660
else:
    import _pyiso9660

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class imaxdiv_t(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    quot = property(_pyiso9660.imaxdiv_t_quot_get, _pyiso9660.imaxdiv_t_quot_set)
    rem = property(_pyiso9660.imaxdiv_t_rem_get, _pyiso9660.imaxdiv_t_rem_set)

    def __init__(self):
        r"""Return true if ISO 9660 image has extended attrributes (XA)."""
        _pyiso9660.imaxdiv_t_swiginit(self, _pyiso9660.new_imaxdiv_t())
    __swig_destroy__ = _pyiso9660.delete_imaxdiv_t

# Register imaxdiv_t in _pyiso9660:
_pyiso9660.imaxdiv_t_swigregister(imaxdiv_t)

def imaxabs(n):
    return _pyiso9660.imaxabs(n)

def imaxdiv(numer, denom):
    return _pyiso9660.imaxdiv(numer, denom)

def wcstoimax(nptr, endptr, base):
    return _pyiso9660.wcstoimax(nptr, endptr, base)

def wcstoumax(nptr, endptr, base):
    return _pyiso9660.wcstoumax(nptr, endptr, base)

def strtoimax(nptr, endptr, base):
    return _pyiso9660.strtoimax(nptr, endptr, base)

def strtoumax(nptr, endptr, base):
    return _pyiso9660.strtoumax(nptr, endptr, base)
VERSION_NUM = _pyiso9660.VERSION_NUM
INVALID_LBA = _pyiso9660.INVALID_LBA
INVALID_LSN = _pyiso9660.INVALID_LSN
CD_FRAMESIZE = _pyiso9660.CD_FRAMESIZE
CD_FRAMESIZE_RAW = _pyiso9660.CD_FRAMESIZE_RAW
ISO_BLOCKSIZE = _pyiso9660.ISO_BLOCKSIZE
M2F2_SECTOR_SIZE = _pyiso9660.M2F2_SECTOR_SIZE
M2RAW_SECTOR_SIZE = _pyiso9660.M2RAW_SECTOR_SIZE
PVD_SECTOR = _pyiso9660.PVD_SECTOR

EVD_SECTOR = _pyiso9660.EVD_SECTOR

LEN_ISONAME = _pyiso9660.LEN_ISONAME

MAX_SYSTEM_ID = _pyiso9660.MAX_SYSTEM_ID

MAX_ISONAME = _pyiso9660.MAX_ISONAME

MAX_PREPARER_ID = _pyiso9660.MAX_PREPARER_ID

MAX_ISOPATHNAME = _pyiso9660.MAX_ISOPATHNAME

FILE = _pyiso9660.FILE

EXISTENCE = _pyiso9660.EXISTENCE

DIRECTORY = _pyiso9660.DIRECTORY

ASSOCIATED = _pyiso9660.ASSOCIATED

RECORD = _pyiso9660.RECORD

PROTECTION = _pyiso9660.PROTECTION

DRESERVED1 = _pyiso9660.DRESERVED1

DRESERVED2 = _pyiso9660.DRESERVED2

MULTIEXTENT = _pyiso9660.MULTIEXTENT

VD_BOOT_RECORD = _pyiso9660.VD_BOOT_RECORD

VD_PRIMARY = _pyiso9660.VD_PRIMARY

VD_SUPPLEMENTARY = _pyiso9660.VD_SUPPLEMENTARY

VD_PARITION = _pyiso9660.VD_PARITION

VD_END = _pyiso9660.VD_END

MAX_PUBLISHER_ID = _pyiso9660.MAX_PUBLISHER_ID

MAX_APPLICATION_ID = _pyiso9660.MAX_APPLICATION_ID

MAX_VOLUME_ID = _pyiso9660.MAX_VOLUME_ID

MAX_VOLUMESET_ID = _pyiso9660.MAX_VOLUMESET_ID

STANDARD_ID = _pyiso9660.STANDARD_ID

NOCHECK = _pyiso9660.NOCHECK

SEVEN_BIT = _pyiso9660.SEVEN_BIT

ACHARS = _pyiso9660.ACHARS

DCHARS = _pyiso9660.DCHARS

EXTENSION_JOLIET_LEVEL1 = _pyiso9660.EXTENSION_JOLIET_LEVEL1

EXTENSION_JOLIET_LEVEL2 = _pyiso9660.EXTENSION_JOLIET_LEVEL2

EXTENSION_JOLIET_LEVEL3 = _pyiso9660.EXTENSION_JOLIET_LEVEL3

EXTENSION_ROCK_RIDGE = _pyiso9660.EXTENSION_ROCK_RIDGE

EXTENSION_HIGH_SIERRA = _pyiso9660.EXTENSION_HIGH_SIERRA

EXTENSION_ALL = _pyiso9660.EXTENSION_ALL

EXTENSION_NONE = _pyiso9660.EXTENSION_NONE

EXTENSION_JOLIET = _pyiso9660.EXTENSION_JOLIET


def open_iso(psz_path):
    r"""
    open_iso(path)
     Open an ISO 9660 image for reading. Maybe in the future we will have
     mode. None is returned on error.

    """
    return _pyiso9660.open_iso(psz_path)

def open_ext(psz_path, iso_extension_mask):
    r"""
    Open an ISO 9660 image for reading allowing various ISO 9660
     extensions.  Maybe in the future we will have a mode. None is
     returned on error.
    """
    return _pyiso9660.open_ext(psz_path, iso_extension_mask)

def open_fuzzy(psz_path, i_fuzz):
    r"""
    Open an ISO 9660 image for reading with some tolerence for positioning
    of the ISO9660 image. We scan for ISO_STANDARD_ID and use that to set
    the eventual offset to adjust by (as long as that is <= i_fuzz).

    Maybe in the future we will have a mode. None is returned on error.

    see iso9660_open
    """
    return _pyiso9660.open_fuzzy(psz_path, i_fuzz)

def iso9660_open_fuzzy_ext(psz_path, iso_extension_mask, i_fuzz):
    r"""
    Open an ISO 9660 image for reading with some tolerence for positioning
    of the ISO9660 image. We scan for ISO_STANDARD_ID and use that to set
    the eventual offset to adjust by (as long as that is <= i_fuzz).

    Maybe in the future we will have a mode. None is returned on error.

    see open_iso

    """
    return _pyiso9660.iso9660_open_fuzzy_ext(psz_path, iso_extension_mask, i_fuzz)

def ifs_fuzzy_read_superblock(p_iso, iso_extension_mask, i_fuzz):
    r"""
    Read the Super block of an ISO 9660 image but determine framesize
    and datastart and a possible additional offset. Generally here we are
    not reading an ISO 9660 image but a CD-Image which contains an ISO 9660
    filesystem.

    """
    return _pyiso9660.ifs_fuzzy_read_superblock(p_iso, iso_extension_mask, i_fuzz)

def close(p_iso):
    r"""
    Close previously opened ISO 9660 image.
    True is unconditionally returned. If there was an error false would
    be returned.
    """
    return _pyiso9660.close(p_iso)

def seek_read(p_iso, start, p_buf):
    r"""
    Seek to a position and then read n bytes. (buffer, size) are
     returned.
    """
    return _pyiso9660.seek_read(p_iso, start, p_buf)

def fs_read_pvd(p_cdio):
    r"""
    Read the Primary Volume Descriptor for a CD.
    None  is returned if there was an error.
    """
    return _pyiso9660.fs_read_pvd(p_cdio)

def ifs_read_pvd(p_iso):
    r"""
    Read the Primary Volume Descriptor for an ISO 9660 image.
    None is returned if there was an error.
    """
    return _pyiso9660.ifs_read_pvd(p_iso)

def fs_read_superblock(p_cdio, iso_extension_mask):
    r"""
    Read the Super block of an ISO 9660 image. This is the
    Primary Volume Descriptor (PVD) and perhaps a Supplemental Volume
    Descriptor if (Joliet) extensions are acceptable.
    """
    return _pyiso9660.fs_read_superblock(p_cdio, iso_extension_mask)

def ifs_read_superblock(p_iso, iso_extension_mask):
    r"""
    Read the Super block of an ISO 9660 image. This is the
     Primary Volume Descriptor (PVD) and perhaps a Supplemental Volume
     Descriptor if (Joliet) extensions are acceptable.
    """
    return _pyiso9660.ifs_read_superblock(p_iso, iso_extension_mask)

def set_dtime(year, mon, mday, hour, min, sec):
    r"""Set time in format used in ISO 9660 directory index record"""
    return _pyiso9660.set_dtime(year, mon, mday, hour, min, sec)

def set_ltime(year, mon, mday, hour, min, sec):
    r"""Set 'long' time in format used in ISO 9660 primary volume descriptor"""
    return _pyiso9660.set_ltime(year, mon, mday, hour, min, sec)

def get_dtime(p_dtime, use_localtime):
    r"""
    Get Unix time structure from format use in an ISO 9660 directory index
    record. Even though tm_wday and tm_yday fields are not explicitly in
    idr_date, they are calculated from the other fields.

    If tm is to reflect the localtime, set 'use_localtime' true, otherwise
    tm will reported in GMT.
    """
    return _pyiso9660.get_dtime(p_dtime, use_localtime)

def get_ltime(p_ltime):
    r"""
    Get 'long' time in format used in ISO 9660 primary volume descriptor
     from a Unix time structure.
    """
    return _pyiso9660.get_ltime(p_ltime)

def is_dchar(c):
    r"""
    Return true if c is a DCHAR - a character that can appear in an an
    ISO-9600 level 1 directory name. These are the ASCII capital
    letters A-Z, the digits 0-9 and an underscore.
    """
    return _pyiso9660.is_dchar(c)

def is_achar(c):
    r"""
    Return true if c is an ACHAR -
     These are the DCHAR's plus some ASCII symbols including the space
     symbol.
    """
    return _pyiso9660.is_achar(c)

def name_translate(psz_oldname):
    r"""
    Convert an ISO-9660 file name that stored in a directory entry into
     what's usually listed as the file name in a listing.
     Lowercase name, and remove trailing ;1's or .;1's and
     turn the other ;'s into version numbers.

     @param psz_oldname the ISO-9660 filename to be translated.
     @param psz_newname returned string. The caller allocates this and
     it should be at least the size of psz_oldname.
     @return length of the translated string is returned.
    """
    return _pyiso9660.name_translate(psz_oldname)

def name_translate_ext(psz_oldname, i_joliet_level):
    r"""
    Convert an ISO-9660 file name that stored in a directory entry into
     what's usually listed as the file name in a listing.  Lowercase
     name if no Joliet Extension interpretation. Remove trailing ;1's or
     .;1's and turn the other ;'s into version numbers.

     @param psz_oldname the ISO-9660 filename to be translated.
     @param psz_newname returned string. The caller allocates this and
     it should be at least the size of psz_oldname.
     @param i_joliet_level 0 if not using Joliet Extension. Otherwise the
     Joliet level.
     @return length of the translated string is returned. It will be no greater
     than the length of psz_oldname.
    """
    return _pyiso9660.name_translate_ext(psz_oldname, i_joliet_level)

def strncpy_pad(src, len, _check):
    r"""
    Pad string src with spaces to size len and copy this to dst. If
     en is less than the length of src, dst will be truncated to the
     first len characters of src.

     src can also be scanned to see if it contains only ACHARs, DCHARs,
     7-bit ASCII chars depending on the enumeration _check.

     In addition to getting changed, dst is the return value.
     Note: this string might not be NULL terminated.
    """
    return _pyiso9660.strncpy_pad(src, len, _check)

def dirname_valid_p(psz_path):
    r"""
    Check that psz_path is a valid ISO-9660 directory name.

     A valid directory name should not start out with a slash (/),
     dot (.) or null byte, should be less than 37 characters long,
     have no more than 8 characters in a directory component
     which is separated by a /, and consist of only DCHARs.

     True is returned if psz_path is valid.
    """
    return _pyiso9660.dirname_valid_p(psz_path)

def pathname_isofy(psz_path, i_version=1):
    r"""
    Take psz_path and a version number and turn that into a ISO-9660
    pathname.  (That's just the pathname followed by ';' and the version
    number. For example, mydir/file.ext -> MYDIR/FILE.EXT;1 for version
    1. The resulting ISO-9660 pathname is returned.
    """
    return _pyiso9660.pathname_isofy(psz_path, i_version)

def pathname_valid_p(psz_path):
    r"""
    Check that psz_path is a valid ISO-9660 pathname.

    A valid pathname contains a valid directory name, if one appears and
    the filename portion should be no more than 8 characters for the
    file prefix and 3 characters in the extension (or portion after a
    dot). There should be exactly one dot somewhere in the filename
    portion and the filename should be composed of only DCHARs.

    True is returned if psz_path is valid.
    """
    return _pyiso9660.pathname_valid_p(psz_path)

def fs_stat(p_cdio, psz_path):
    r"""Return file status for psz_path. None is returned on error."""
    return _pyiso9660.fs_stat(p_cdio, psz_path)

def fs_stat_translate(p_cdio, psz_path):
    r"""
    Return file status for path name psz_path. None is returned on error.
    pathname version numbers in the ISO 9660 name are dropped, i.e. ;1
    is removed and if level 1 ISO-9660 names are lowercased.
    """
    return _pyiso9660.fs_stat_translate(p_cdio, psz_path)

def ifs_stat(p_iso, psz_path):
    r"""Return file status for pathname. None is returned on error."""
    return _pyiso9660.ifs_stat(p_iso, psz_path)

def ifs_stat_translate(p_iso, psz_path):
    r"""
    Return file status for path name psz_path. undef is returned on error.
    pathname version numbers in the ISO 9660 name are dropped, i.e. ;1 is
    removed and if level 1 ISO-9660 names are lowercased.
    """
    return _pyiso9660.ifs_stat_translate(p_iso, psz_path)

def fs_readdir(p_cdio, psz_path):
    r"""
    Read psz_path (a directory) and return a list of iso9660_stat_t
    pointers for the files inside that directory.
    """
    return _pyiso9660.fs_readdir(p_cdio, psz_path)

def ifs_readdir(p_iso, psz_path):
    r"""
    Read psz_path (a directory) and return a list of iso9660_stat_t
    pointers for the files inside that directory.
    """
    return _pyiso9660.ifs_readdir(p_iso, psz_path)

def get_application_id(p_pvd):
    r"""
    Return the PVD's application ID.
    None is returned if there is some problem in getting this.
    """
    return _pyiso9660.get_application_id(p_pvd)

def ifs_get_application_id(p_iso):
    r"""
    Get the application ID.  Return None if there
    is some problem in getting this.
    """
    return _pyiso9660.ifs_get_application_id(p_iso)

def get_joliet_level(p_iso):
    r"""Return the Joliet level recognized for p_iso."""
    return _pyiso9660.get_joliet_level(p_iso)

def get_dir_len(p_idr):
    r"""Return the Joliet level recognized for p_iso."""
    return _pyiso9660.get_dir_len(p_idr)

def iso9660_dir_to_name(p_iso9660_dir):
    r"""Return the directory name stored in the iso9660_dir_t."""
    return _pyiso9660.iso9660_dir_to_name(p_iso9660_dir)

def get_posix_filemode(p_iso_dirent):
    r"""Returns a POSIX mode for a given p_iso_dirent."""
    return _pyiso9660.get_posix_filemode(p_iso_dirent)

def get_preparer_id(p_pvd):
    r"""
    Return a string containing the preparer id with trailing
    blanks removed.
    """
    return _pyiso9660.get_preparer_id(p_pvd)

def ifs_get_preparer_id(p_iso):
    r"""
    Get the preparer ID.  Return None if there is some problem in
     getting this.
    """
    return _pyiso9660.ifs_get_preparer_id(p_iso)

def get_publisher_id(p_pvd):
    r"""
    Return a string containing the PVD's publisher id with trailing
     blanks removed.
    """
    return _pyiso9660.get_publisher_id(p_pvd)

def ifs_get_publisher_id(p_iso):
    r"""
    Get the publisher ID. Return None if there
    is some problem in getting this.
    """
    return _pyiso9660.ifs_get_publisher_id(p_iso)

def get_pvd_type(p_pvd):
    r"""
    Get the publisher ID. Return None if there
    is some problem in getting this.
    """
    return _pyiso9660.get_pvd_type(p_pvd)

def get_pvd_id(p_pvd):
    r"""
    Get the publisher ID. Return None if there
    is some problem in getting this.
    """
    return _pyiso9660.get_pvd_id(p_pvd)

def get_pvd_space_size(p_pvd):
    r"""
    Get the publisher ID. Return None if there
    is some problem in getting this.
    """
    return _pyiso9660.get_pvd_space_size(p_pvd)

def get_pvd_block_size(p_pvd):
    r"""
    Get the publisher ID. Return None if there
    is some problem in getting this.
    """
    return _pyiso9660.get_pvd_block_size(p_pvd)

def get_pvd_version(pvd):
    r"""
    Return the primary volume id version number (of pvd).
    If there is an error 0 is returned.
    """
    return _pyiso9660.get_pvd_version(pvd)

def get_system_id(p_pvd):
    r"""
    Return a string containing the PVD's system id with trailing
     blanks removed.
    """
    return _pyiso9660.get_system_id(p_pvd)

def ifs_get_system_id(p_iso):
    r"""
    Get the system ID.  None is returned if there
    is some problem in getting this.
    """
    return _pyiso9660.ifs_get_system_id(p_iso)

def get_root_lsn(p_pvd):
    r"""
    Return the LSN of the root directory for pvd.  If there is an error
    INVALID_LSN is returned.

    """
    return _pyiso9660.get_root_lsn(p_pvd)

def get_volume_id(p_pvd):
    r"""Return the PVD's volume ID."""
    return _pyiso9660.get_volume_id(p_pvd)

def ifs_get_volume_id(p_iso):
    r"""
    Get the system ID. None is returned if there
    is some problem in getting this.
    """
    return _pyiso9660.ifs_get_volume_id(p_iso)

def get_volumeset_id(p_pvd):
    r"""
    Return the PVD's volumeset ID.
    None is returned if there is some problem in getting this.

    """
    return _pyiso9660.get_volumeset_id(p_pvd)

def ifs_get_volumeset_id(p_iso):
    r"""
    Get the volumeset ID.  None is returned if there
    is some problem in getting this.
    """
    return _pyiso9660.ifs_get_volumeset_id(p_iso)

def pathtable_init(pt):
    r"""Zero's out pathable. Do this first."""
    return _pyiso9660.pathtable_init(pt)

def pathtable_get_size(pt):
    r"""Zero's out pathable. Do this first."""
    return _pyiso9660.pathtable_get_size(pt)

def pathtable_l_add_entry(pt, name, extent, parent):
    r"""Zero's out pathable. Do this first."""
    return _pyiso9660.pathtable_l_add_entry(pt, name, extent, parent)

def pathtable_m_add_entry(pt, name, extent, parent):
    r"""Zero's out pathable. Do this first."""
    return _pyiso9660.pathtable_m_add_entry(pt, name, extent, parent)

def set_evd(pd):
    r"""Zero's out pathable. Do this first."""
    return _pyiso9660.set_evd(pd)

def is_xa(p_iso):
    r"""Return true if ISO 9660 image has extended attrributes (XA)."""
    return _pyiso9660.is_xa(p_iso)

