# Orca
#
# Copyright 2004-2009 Sun Microsystems Inc.
# Copyright 2010-2013 The Orca Team
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., Franklin Street, Fifth Floor,
# Boston MA  02110-1301 USA.

"""Braille translation table names. These have been put in their own module
so that we can present them in the correct language when users change the 
synthesizer language on the fly without having to reload a bunch of modules."""

__id__        = "$Id$"
__version__   = "$Revision$"
__date__      = "$Date$"
__copyright__ = "Copyright (c) 2004-2009 Sun Microsystems Inc." \
                "Copyright (c) 2010-2013 The Orca Team"
__license__   = "LGPL"

from .orca_i18n import _ # pylint: disable=import-error

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
CZ_CZ_G1   = _("Czech Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
ES_ES_G1   = _("Spanish Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
FR_CA_G2   = _("Canada French Grade 2")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
FR_FR_G2   = _("France French Grade 2")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
LV_LV_G1   = _("Latvian Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
NL_NL_G1   = _("Netherlands Dutch Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
NO_NO_G0   = _("Norwegian Grade 0")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
NO_NO_G1   = _("Norwegian Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
NO_NO_G2   = _("Norwegian Grade 2")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
NO_NO_G3   = _("Norwegian Grade 3")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
PL_PL_G1   = _("Polish Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
PT_PT_G1   = _("Portuguese Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
SE_SE_G1   = _("Swedish Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
AR_AR_G1   = _("Arabic Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
CY_CY_G1   = _("Welsh Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
CY_CY_G2   = _("Welsh Grade 2")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
DE_DE_G0   = _("German Grade 0")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
DE_DE_G1   = _("German Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
DE_DE_G2   = _("German Grade 2")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
EN_GB_G2   = _("U.K. English Grade 2")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
EN_GB_G1   = _("U.K. English Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
EN_US_G1   = _("U.S. English Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
EN_US_G2   = _("U.S. English Grade 2")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
FR_CA_G1   = _("Canada French Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
FR_FR_G1   = _("France French Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
GR_GR_G1   = _("Greek Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
HI_IN_G1   = _("Hindi Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
HU_HU_8DOT = _("Hungarian 8 dot computer")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
HU_HU_G1   = _("Hungarian Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
HU_HU_G2   = _("Hungarian Grade 2")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
IT_IT_G1   = _("Italian Grade 1")

# Translators: This is the name of a braille translation table. To learn more
# about braille translation tables, see http://en.wikipedia.org/wiki/Braille.
NL_BE_G1   = _("Belgium Dutch Grade 1")
