/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.repackage.com.google.common.collect;

import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.opensearch.ml.repackage.com.google.common.annotations.GwtCompatible;
import org.opensearch.ml.repackage.com.google.common.base.Preconditions;
import org.opensearch.ml.repackage.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.opensearch.ml.repackage.com.google.common.collect.ForwardingCollection;
import org.opensearch.ml.repackage.com.google.common.collect.Sets;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSet<E>
extends ForwardingCollection<E>
implements Set<E> {
    protected ForwardingSet() {
    }

    @Override
    protected abstract Set<E> delegate();

    @Override
    public boolean equals(@CheckForNull Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Sets.removeAllImpl(this, Preconditions.checkNotNull(collection));
    }

    protected boolean standardEquals(@CheckForNull Object object) {
        return Sets.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this);
    }
}

