/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.utils.FieldDescriptor;
import org.opensearch.ml.common.utils.ToStringTypeAdapter;

public class StringUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(StringUtils.class);
    public static final String DEFAULT_ESCAPE_FUNCTION = "\n    String escape(def input) { \n      if (input.contains(\"\\\\\")) {\n        input = input.replace(\"\\\\\", \"\\\\\\\\\");\n      }\n      if (input.contains(\"\\\"\")) {\n        input = input.replace(\"\\\"\", \"\\\\\\\"\");\n      }\n      if (input.contains('\r')) {\n        input = input = input.replace('\r', '\\\\r');\n      }\n      if (input.contains(\"\\\\t\")) {\n        input = input.replace(\"\\\\t\", \"\\\\\\\\\\\\t\");\n      }\n      if (input.contains('\n')) {\n        input = input.replace('\n', '\\\\n');\n      }\n      if (input.contains('\b')) {\n        input = input.replace('\b', '\\\\b');\n      }\n      if (input.contains('\f')) {\n        input = input.replace('\f', '\\\\f');\n      }\n      return input;\n    }\n";
    private static final Pattern SAFE_INPUT_PATTERN = Pattern.compile("^[\\p{L}\\p{N}\\s.,!?():@\\-_/'\"]*$");
    public static final String SAFE_INPUT_DESCRIPTION = "can only contain letters, numbers, spaces, and basic punctuation (.,!?():@-_'/\")";
    public static final Gson PLAIN_NUMBER_GSON = new GsonBuilder().serializeNulls().registerTypeAdapter(Float.class, (Object)new PlainFloatAdapter()).registerTypeAdapter(Float.TYPE, (Object)new PlainFloatAdapter()).registerTypeAdapter(Double.class, (Object)new PlainDoubleAdapter()).registerTypeAdapter(Double.TYPE, (Object)new PlainDoubleAdapter()).create();
    public static final Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(ModelTensor.class, new ToStringTypeAdapter<ModelTensor>(ModelTensor.class)).registerTypeAdapter(ModelTensorOutput.class, new ToStringTypeAdapter<ModelTensorOutput>(ModelTensorOutput.class)).registerTypeAdapter(ModelTensors.class, new ToStringTypeAdapter<ModelTensors>(ModelTensors.class)).serializeNulls().create();
    public static final String TO_STRING_FUNCTION_NAME = ".toString()";
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static boolean isValidJsonString(String json) {
        if (json == null || json.isBlank()) {
            return false;
        }
        try {
            new JSONObject(json);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(json);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJson(String json) {
        if (json == null || json.isBlank()) {
            return false;
        }
        try {
            if (!StringUtils.isValidJsonString(json)) {
                return false;
            }
            gson.fromJson(json, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    public static String prepareJsonValue(String input) {
        if (StringUtils.isJson(input)) {
            return input;
        }
        return StringEscapeUtils.escapeJson((String)input);
    }

    public static String toUTF8(String rawString) {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(rawString);
        String utf8EncodedString = StandardCharsets.UTF_8.decode(buffer).toString();
        return utf8EncodedString;
    }

    public static Map<String, Object> fromJson(String jsonStr, String defaultKey) {
        HashMap<String, List> result;
        JsonElement jsonElement = JsonParser.parseString((String)jsonStr);
        if (jsonElement.isJsonObject()) {
            result = (HashMap<String, List>)gson.fromJson(jsonElement, Map.class);
        } else if (jsonElement.isJsonArray()) {
            List list = (List)gson.fromJson(jsonElement, List.class);
            result = new HashMap<String, List>();
            result.put(defaultKey, list);
        } else {
            throw new IllegalArgumentException("Unsupported response type");
        }
        return result;
    }

    public static Map<String, Object> fromJsonWithWrappingKey(String jsonStr, String wrappingKey) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JsonElement jsonElement = JsonParser.parseString((String)jsonStr);
        if (jsonElement.isJsonObject()) {
            Map parsedMap = (Map)gson.fromJson(jsonElement, Map.class);
            result.put(wrappingKey, parsedMap);
        } else if (jsonElement.isJsonArray()) {
            List list = (List)gson.fromJson(jsonElement, List.class);
            result.put(wrappingKey, list);
        } else {
            throw new IllegalArgumentException("Unsupported response type");
        }
        return result;
    }

    public static Map<String, String> filteredParameterMap(Map<String, ?> parameterObjs, Set<String> allowedList) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashSet<String> filteredKeys = new HashSet<String>(parameterObjs.keySet());
        filteredKeys.retainAll(allowedList);
        for (String key : filteredKeys) {
            Object value = parameterObjs.get(key);
            try {
                AccessController.doPrivileged(() -> {
                    if (value instanceof String) {
                        parameters.put(key, (String)value);
                    } else {
                        parameters.put(key, gson.toJson(value));
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        return parameters;
    }

    public static Map<String, String> getParameterMap(Map<String, ?> parameterObjs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (parameterObjs == null) {
            return parameters;
        }
        for (String key : parameterObjs.keySet()) {
            Object value = parameterObjs.get(key);
            try {
                AccessController.doPrivileged(() -> {
                    if (value instanceof String) {
                        parameters.put(key, (String)value);
                    } else {
                        parameters.put(key, gson.toJson(value));
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        return parameters;
    }

    public static String toJson(Object value) {
        try {
            return AccessController.doPrivileged(() -> {
                if (value instanceof String) {
                    return (String)value;
                }
                return gson.toJson(value);
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> convertScriptStringToJsonString(Map<String, Object> processedInput) {
        HashMap<String, String> parameterStringMap = new HashMap<String, String>();
        try {
            AccessController.doPrivileged(() -> {
                Map parametersMap = processedInput.getOrDefault("parameters", Map.of());
                for (String key : parametersMap.keySet()) {
                    if (parametersMap.get(key) instanceof String) {
                        parameterStringMap.put(key, (String)parametersMap.get(key));
                        continue;
                    }
                    parameterStringMap.put(key, gson.toJson(parametersMap.get(key)));
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            log.error("Error processing parameters", (Throwable)e);
            throw new RuntimeException(e);
        }
        return parameterStringMap;
    }

    public static List<String> processTextDocs(List<String> inputDocs) {
        ArrayList<String> docs = new ArrayList<String>();
        for (String doc : inputDocs) {
            docs.add(StringUtils.processTextDoc(doc));
        }
        return docs;
    }

    public static String processTextDoc(String doc) {
        if (doc != null) {
            String gsonString = gson.toJson((Object)doc);
            return gsonString.substring(1, gsonString.length() - 1);
        }
        return null;
    }

    public static String addDefaultMethod(String functionScript) {
        if (!StringUtils.containsEscapeMethod(functionScript) && StringUtils.isEscapeUsed(functionScript)) {
            return DEFAULT_ESCAPE_FUNCTION + functionScript;
        }
        return functionScript;
    }

    public static boolean patternExist(String input, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }

    public static boolean isEscapeUsed(String input) {
        return StringUtils.patternExist(input, "(?<!\\bString\\s+)\\bescape\\s*\\(");
    }

    public static boolean containsEscapeMethod(String input) {
        return StringUtils.patternExist(input, "String\\s+escape\\s*\\(\\s*(def|String)\\s+.*?\\)\\s*\\{?");
    }

    public static String getErrorMessage(String errorMessage, String modelId, Boolean isHidden) {
        if (BooleanUtils.isTrue((Boolean)isHidden)) {
            return errorMessage;
        }
        return errorMessage + " Model ID: " + modelId;
    }

    public static List<String> collectToStringPrefixes(Map<String, String> map) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String key : map.keySet()) {
            String value = map.get(key);
            if (value == null) continue;
            Pattern pattern = Pattern.compile("\\$\\{parameters\\.(.+?)\\.toString\\(\\)\\}");
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String prefix = matcher.group(1);
                prefixes.add(prefix);
            }
        }
        return prefixes;
    }

    public static Map<String, String> parseParameters(Map<String, String> parameters) {
        List<String> toStringParametersPrefixes;
        if (parameters != null && !(toStringParametersPrefixes = StringUtils.collectToStringPrefixes(parameters)).isEmpty()) {
            for (String prefix : toStringParametersPrefixes) {
                String value = parameters.get(prefix);
                if (value == null) continue;
                parameters.put(prefix + TO_STRING_FUNCTION_NAME, StringUtils.processTextDoc(value));
            }
        }
        return parameters;
    }

    public static String obtainFieldNameFromJsonPath(String jsonPath) {
        String[] parts = jsonPath.split("\\.");
        return parts[parts.length - 1];
    }

    public static String getJsonPath(String jsonPathWithSource) {
        int startIndex = jsonPathWithSource.indexOf("$.");
        return startIndex != -1 ? jsonPathWithSource.substring(startIndex) : jsonPathWithSource;
    }

    public static boolean isValidJSONPath(String input) {
        if (input == null || input.isBlank()) {
            return false;
        }
        try {
            JsonPath.compile((String)input, (Predicate[])new Predicate[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JsonObject getJsonObjectFromString(String jsonString) {
        if (jsonString == null || jsonString.isBlank()) {
            throw new IllegalArgumentException("Json cannot be null or empty");
        }
        return JsonParser.parseString((String)jsonString).getAsJsonObject();
    }

    public static boolean pathExists(Object json, String path) {
        if (json == null) {
            throw new IllegalArgumentException("JSON object cannot be null");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path cannot be null or empty");
        }
        if (!StringUtils.isValidJSONPath(path)) {
            throw new IllegalArgumentException("the field path is not a valid json path: " + path);
        }
        try {
            JsonPath.read((Object)json, (String)path, (Predicate[])new Predicate[0]);
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public static Object prepareNestedStructures(Object jsonObject, String fieldPath) {
        if (fieldPath == null) {
            throw new IllegalArgumentException("The field path is null");
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("The object is null");
        }
        if (!StringUtils.isValidJSONPath(fieldPath)) {
            throw new IllegalArgumentException("The field path is not a valid JSON path: " + fieldPath);
        }
        String path = fieldPath.startsWith("$.") ? fieldPath.substring(2) : fieldPath;
        String[] pathParts = path.split("(?<!\\\\)\\.");
        Map current = jsonObject instanceof Map ? (Map)jsonObject : new HashMap();
        for (String part : pathParts) {
            if (part.contains("[")) {
                String[] arrayParts = part.split("\\[");
                String key = arrayParts[0];
                int index = Integer.parseInt(arrayParts[1].replaceAll("\\]", ""));
                if (!current.containsKey(key)) {
                    current.put(key, new ArrayList());
                }
                if (!(current.get(key) instanceof List)) {
                    return jsonObject;
                }
                List list = (List)current.get(key);
                if (index >= list.size()) {
                    while (list.size() <= index) {
                        list.add(null);
                    }
                    list.set(index, new HashMap());
                }
                if (!(list.get(index) instanceof Map)) {
                    return jsonObject;
                }
                current = (Map)list.get(index);
                continue;
            }
            if (!current.containsKey(part)) {
                current.put(part, new HashMap());
            } else if (!(current.get(part) instanceof Map)) {
                return jsonObject;
            }
            current = (Map)current.get(part);
        }
        return jsonObject;
    }

    public static void validateSchema(String schemaString, String instanceString) {
        try {
            JsonNode schemaNode = MAPPER.readTree(schemaString);
            JsonSchema schema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012).getSchema(schemaNode);
            JsonNode jsonNode = MAPPER.readTree(instanceString);
            Set errors = schema.validate(jsonNode);
            if (!errors.isEmpty()) {
                String errorMessage = errors.stream().map(ValidationMessage::getMessage).collect(Collectors.joining(", "));
                throw new OpenSearchParseException("Validation failed: " + errorMessage + " for instance: " + instanceString + " with schema: " + schemaString, new Object[0]);
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid JSON format: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new OpenSearchParseException("Schema validation failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public static String hashString(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(input.getBytes());
            return Base64.getUrlEncoder().encodeToString(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error: Unable to compute hash", e);
        }
    }

    public static ActionRequestValidationException validateFields(Map<String, FieldDescriptor> fields) {
        ActionRequestValidationException exception = null;
        for (Map.Entry<String, FieldDescriptor> entry : fields.entrySet()) {
            String key = entry.getKey();
            FieldDescriptor descriptor = entry.getValue();
            String value = descriptor.getValue();
            if (descriptor.isRequired()) {
                if (StringUtils.isSafeText(value)) continue;
                String reason = value == null || value.isBlank() ? "is required and cannot be null or blank" : SAFE_INPUT_DESCRIPTION;
                exception = ValidateActions.addValidationError((String)(key + " " + reason), exception);
                continue;
            }
            if (value == null || value.isBlank() || StringUtils.matchesSafePattern(value)) continue;
            exception = ValidateActions.addValidationError((String)(key + " can only contain letters, numbers, spaces, and basic punctuation (.,!?():@-_'/\")"), exception);
        }
        return exception;
    }

    public static boolean isSafeText(String value) {
        return value != null && !value.isBlank() && StringUtils.matchesSafePattern(value);
    }

    public static boolean matchesSafePattern(String value) {
        return SAFE_INPUT_PATTERN.matcher(value).matches();
    }

    public static List<String> parseStringArrayToList(String jsonArrayString) {
        if (jsonArrayString == null || jsonArrayString.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return (List)gson.fromJson(jsonArrayString, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to parse JSON array string: {}", (Object)jsonArrayString, (Object)e);
            return Collections.emptyList();
        }
    }

    public static class PlainFloatAdapter
    extends TypeAdapter<Float> {
        public void write(JsonWriter out, Float value) throws IOException {
            if (value == null || value.isNaN() || value.isInfinite()) {
                out.nullValue();
                return;
            }
            BigDecimal bd = new BigDecimal(Float.toString(value.floatValue())).stripTrailingZeros();
            out.jsonValue(bd.toPlainString());
        }

        public Float read(JsonReader in) throws IOException {
            double d = in.nextDouble();
            float f = (float)d;
            return Float.valueOf(f);
        }
    }

    private static class PlainDoubleAdapter
    extends TypeAdapter<Double> {
        private PlainDoubleAdapter() {
        }

        public void write(JsonWriter out, Double value) throws IOException {
            if (value == null || value.isNaN() || value.isInfinite()) {
                out.nullValue();
                return;
            }
            BigDecimal bd = BigDecimal.valueOf(value).stripTrailingZeros();
            out.jsonValue(bd.toPlainString());
        }

        public Double read(JsonReader in) throws IOException {
            return in.nextDouble();
        }
    }
}

