/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MessageInput
implements ToXContentObject,
Writeable {
    private String role;
    private List<Map<String, Object>> content;

    public MessageInput(String role, List<Map<String, Object>> content) {
        this.role = role;
        this.content = content;
        if (role == null || content == null) {
            throw new IllegalArgumentException("Message must have role and content");
        }
    }

    public MessageInput(StreamInput in) throws IOException {
        this.role = in.readOptionalString();
        if (in.readBoolean()) {
            this.content = in.readList(StreamInput::readMap);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.role);
        if (this.content != null) {
            out.writeBoolean(true);
            out.writeCollection(this.content, StreamOutput::writeMap);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.role != null) {
            builder.field("role", this.role);
        }
        if (this.content != null) {
            builder.field("content", this.content);
        }
        builder.endObject();
        return builder;
    }

    public static MessageInput parse(XContentParser parser) throws IOException {
        String role = null;
        ArrayList<Map> content = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "role": {
                    role = parser.text();
                    continue block8;
                }
                case "content": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    content = new ArrayList<Map>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        content.add(parser.map());
                    }
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return MessageInput.builder().role(role).content(content).build();
    }

    @Generated
    public static MessageInputBuilder builder() {
        return new MessageInputBuilder();
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public List<Map<String, Object>> getContent() {
        return this.content;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public void setContent(List<Map<String, Object>> content) {
        this.content = content;
    }

    @Generated
    public static class MessageInputBuilder {
        @Generated
        private String role;
        @Generated
        private List<Map<String, Object>> content;

        @Generated
        MessageInputBuilder() {
        }

        @Generated
        public MessageInputBuilder role(String role) {
            this.role = role;
            return this;
        }

        @Generated
        public MessageInputBuilder content(List<Map<String, Object>> content) {
            this.content = content;
            return this;
        }

        @Generated
        public MessageInput build() {
            return new MessageInput(this.role, this.content);
        }

        @Generated
        public String toString() {
            return "MessageInput.MessageInputBuilder(role=" + this.role + ", content=" + String.valueOf(this.content) + ")";
        }
    }
}

