/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.memorycontainer.memory.MemoryEvent;
import org.opensearch.ml.common.utils.StringUtils;

public class MLMemoryHistory
implements ToXContentObject,
Writeable {
    private String ownerId;
    private String memoryContainerId;
    private String memoryId;
    private MemoryEvent action;
    private Map<String, Object> before;
    private Map<String, Object> after;
    private Map<String, String> namespace;
    private Map<String, String> tags;
    private Instant createdTime;
    private String tenantId;
    private String error;

    public MLMemoryHistory(String ownerId, String memoryContainerId, String memoryId, MemoryEvent action, Map<String, Object> before, Map<String, Object> after, Map<String, String> namespace, Map<String, String> tags, Instant createdTime, String tenantId, String error) {
        this.ownerId = ownerId;
        this.memoryContainerId = memoryContainerId;
        this.memoryId = memoryId;
        this.action = action;
        this.before = before;
        this.after = after;
        this.namespace = namespace;
        this.tags = tags;
        this.createdTime = createdTime;
        this.tenantId = tenantId;
        this.error = error;
    }

    public MLMemoryHistory(StreamInput in) throws IOException {
        this.ownerId = in.readOptionalString();
        this.memoryContainerId = in.readOptionalString();
        this.memoryId = in.readOptionalString();
        if (in.readBoolean()) {
            this.action = (MemoryEvent)in.readEnum(MemoryEvent.class);
        }
        if (in.readBoolean()) {
            this.before = in.readMap();
        }
        if (in.readBoolean()) {
            this.after = in.readMap();
        }
        this.createdTime = in.readOptionalInstant();
        if (in.readBoolean()) {
            this.namespace = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (in.readBoolean()) {
            this.tags = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.tenantId = in.readOptionalString();
        this.error = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.ownerId);
        out.writeOptionalString(this.memoryContainerId);
        out.writeOptionalString(this.memoryId);
        if (this.action != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.action);
        } else {
            out.writeBoolean(false);
        }
        if (this.before != null) {
            out.writeBoolean(true);
            out.writeMap(this.before);
        } else {
            out.writeBoolean(false);
        }
        if (this.after != null) {
            out.writeBoolean(true);
            out.writeMap(this.after);
        } else {
            out.writeBoolean(false);
        }
        if (this.namespace != null && !this.namespace.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.namespace, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.tags, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalString(this.tenantId);
        out.writeOptionalString(this.error);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.ownerId != null) {
            builder.field("owner_id", this.ownerId);
        }
        if (this.memoryContainerId != null) {
            builder.field("memory_container_id", this.memoryContainerId);
        }
        if (this.memoryId != null) {
            builder.field("memory_id", this.memoryId);
        }
        if (this.action != null) {
            builder.field("action", (Object)this.action);
        }
        if (this.before != null) {
            builder.field("before", this.before);
        }
        if (this.after != null) {
            builder.field("after", this.after);
        }
        if (this.namespace != null && !this.namespace.isEmpty()) {
            builder.field("namespace", this.namespace);
            builder.field("namespace_size", this.namespace.size());
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            builder.field("tags", this.tags);
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        if (this.error != null) {
            builder.field("error", this.error);
        }
        builder.endObject();
        return builder;
    }

    public static MLMemoryHistory parse(XContentParser parser) throws IOException {
        String ownerId = null;
        String memoryContainerId = null;
        String memoryId = null;
        MemoryEvent action = null;
        Map before = null;
        Map after = null;
        Map<String, String> namespace = null;
        Map<String, String> tags = null;
        Instant createdTime = null;
        String tenantId = null;
        String error = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block26: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "owner_id": {
                    ownerId = parser.text();
                    continue block26;
                }
                case "memory_container_id": {
                    memoryContainerId = parser.text();
                    continue block26;
                }
                case "memory_id": {
                    memoryId = parser.text();
                    continue block26;
                }
                case "action": {
                    action = MemoryEvent.fromString(parser.text());
                    continue block26;
                }
                case "before": {
                    before = parser.map();
                    continue block26;
                }
                case "after": {
                    after = parser.map();
                    continue block26;
                }
                case "namespace": {
                    namespace = StringUtils.getParameterMap(parser.map());
                    continue block26;
                }
                case "tags": {
                    tags = StringUtils.getParameterMap(parser.map());
                    continue block26;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block26;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block26;
                }
                case "error": {
                    error = parser.text();
                    continue block26;
                }
            }
            parser.skipChildren();
        }
        return MLMemoryHistory.builder().ownerId(ownerId).memoryContainerId(memoryContainerId).memoryId(memoryId).action(action).before(before).after(after).namespace(namespace).tags(tags).createdTime(createdTime).tenantId(tenantId).error(error).build();
    }

    @Generated
    public static MLMemoryHistoryBuilder builder() {
        return new MLMemoryHistoryBuilder();
    }

    @Generated
    public String getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public String getMemoryId() {
        return this.memoryId;
    }

    @Generated
    public MemoryEvent getAction() {
        return this.action;
    }

    @Generated
    public Map<String, Object> getBefore() {
        return this.before;
    }

    @Generated
    public Map<String, Object> getAfter() {
        return this.after;
    }

    @Generated
    public Map<String, String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @Generated
    public void setMemoryContainerId(String memoryContainerId) {
        this.memoryContainerId = memoryContainerId;
    }

    @Generated
    public void setMemoryId(String memoryId) {
        this.memoryId = memoryId;
    }

    @Generated
    public void setAction(MemoryEvent action) {
        this.action = action;
    }

    @Generated
    public void setBefore(Map<String, Object> before) {
        this.before = before;
    }

    @Generated
    public void setAfter(Map<String, Object> after) {
        this.after = after;
    }

    @Generated
    public void setNamespace(Map<String, String> namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public static class MLMemoryHistoryBuilder {
        @Generated
        private String ownerId;
        @Generated
        private String memoryContainerId;
        @Generated
        private String memoryId;
        @Generated
        private MemoryEvent action;
        @Generated
        private Map<String, Object> before;
        @Generated
        private Map<String, Object> after;
        @Generated
        private Map<String, String> namespace;
        @Generated
        private Map<String, String> tags;
        @Generated
        private Instant createdTime;
        @Generated
        private String tenantId;
        @Generated
        private String error;

        @Generated
        MLMemoryHistoryBuilder() {
        }

        @Generated
        public MLMemoryHistoryBuilder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder action(MemoryEvent action) {
            this.action = action;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder before(Map<String, Object> before) {
            this.before = before;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder after(Map<String, Object> after) {
            this.after = after;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder namespace(Map<String, String> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLMemoryHistoryBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public MLMemoryHistory build() {
            return new MLMemoryHistory(this.ownerId, this.memoryContainerId, this.memoryId, this.action, this.before, this.after, this.namespace, this.tags, this.createdTime, this.tenantId, this.error);
        }

        @Generated
        public String toString() {
            return "MLMemoryHistory.MLMemoryHistoryBuilder(ownerId=" + this.ownerId + ", memoryContainerId=" + this.memoryContainerId + ", memoryId=" + this.memoryId + ", action=" + String.valueOf((Object)this.action) + ", before=" + String.valueOf(this.before) + ", after=" + String.valueOf(this.after) + ", namespace=" + String.valueOf(this.namespace) + ", tags=" + String.valueOf(this.tags) + ", createdTime=" + String.valueOf(this.createdTime) + ", tenantId=" + this.tenantId + ", error=" + this.error + ")";
        }
    }
}

