/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.sparse.accessor.SparseVectorReader;
import org.opensearch.neuralsearch.sparse.data.SparseVector;
import org.opensearch.neuralsearch.sparse.quantization.ByteQuantizationUtil;
import org.opensearch.neuralsearch.sparse.quantization.ByteQuantizer;

public class SparseBinaryDocValuesPassThrough
extends BinaryDocValues
implements SparseVectorReader {
    private final BinaryDocValues delegate;
    private final SegmentInfo segmentInfo;
    private final ByteQuantizer byteQuantizer;

    public SparseBinaryDocValuesPassThrough(BinaryDocValues delegate, SegmentInfo segmentInfo, FieldInfo fieldInfo) {
        this.delegate = delegate;
        this.segmentInfo = segmentInfo;
        this.byteQuantizer = ByteQuantizationUtil.getByteQuantizerIngest(fieldInfo);
    }

    public BytesRef binaryValue() throws IOException {
        return this.delegate.binaryValue();
    }

    public boolean advanceExact(int target) throws IOException {
        return this.delegate.advanceExact(target);
    }

    public int docID() {
        return this.delegate.docID();
    }

    public int nextDoc() throws IOException {
        return this.delegate.nextDoc();
    }

    public int advance(int target) throws IOException {
        return this.delegate.advance(target);
    }

    public long cost() {
        return this.delegate.cost();
    }

    @Override
    public synchronized SparseVector read(int docId) throws IOException {
        if (!this.advanceExact(docId)) {
            return null;
        }
        BytesRef bytesRef = this.binaryValue();
        if (bytesRef == null) {
            return null;
        }
        return new SparseVector(bytesRef, this.byteQuantizer);
    }

    @Generated
    public SegmentInfo getSegmentInfo() {
        return this.segmentInfo;
    }
}

