/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.neuralsearch.util.prune.PruneType;

public class NeuralSparseQueryTwoPhaseInfo
implements Writeable {
    private TwoPhaseStatus status = TwoPhaseStatus.NOT_ENABLED;
    private float twoPhasePruneRatio = 0.0f;
    private PruneType twoPhasePruneType = PruneType.NONE;

    NeuralSparseQueryTwoPhaseInfo() {
    }

    NeuralSparseQueryTwoPhaseInfo(TwoPhaseStatus status, float twoPhasePruneRatio, PruneType twoPhasePruneType) {
        this.status = status;
        this.twoPhasePruneRatio = twoPhasePruneRatio;
        this.twoPhasePruneType = twoPhasePruneType;
    }

    NeuralSparseQueryTwoPhaseInfo(StreamInput in) throws IOException {
        this.status = TwoPhaseStatus.fromInt(in.readInt());
        this.twoPhasePruneRatio = in.readFloat();
        this.twoPhasePruneType = PruneType.fromString(in.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.status.getValue());
        out.writeFloat(this.twoPhasePruneRatio);
        out.writeString(this.twoPhasePruneType.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NeuralSparseQueryTwoPhaseInfo info = (NeuralSparseQueryTwoPhaseInfo)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.twoPhasePruneType, (Object)info.getTwoPhasePruneType());
        equalsBuilder.append(this.twoPhasePruneRatio, info.getTwoPhasePruneRatio());
        equalsBuilder.append(this.status.getValue(), info.getStatus().getValue());
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.twoPhasePruneType, Float.valueOf(this.twoPhasePruneRatio), this.status.getValue()});
    }

    @Generated
    public TwoPhaseStatus getStatus() {
        return this.status;
    }

    @Generated
    public float getTwoPhasePruneRatio() {
        return this.twoPhasePruneRatio;
    }

    @Generated
    public PruneType getTwoPhasePruneType() {
        return this.twoPhasePruneType;
    }

    @Generated
    public void setStatus(TwoPhaseStatus status) {
        this.status = status;
    }

    @Generated
    public void setTwoPhasePruneRatio(float twoPhasePruneRatio) {
        this.twoPhasePruneRatio = twoPhasePruneRatio;
    }

    @Generated
    public void setTwoPhasePruneType(PruneType twoPhasePruneType) {
        this.twoPhasePruneType = twoPhasePruneType;
    }

    public static enum TwoPhaseStatus {
        NOT_ENABLED(0),
        PHASE_ONE(1),
        PHASE_TWO(2);

        private static final Map<Integer, TwoPhaseStatus> VALUE_MAP;
        private final int value;

        private TwoPhaseStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TwoPhaseStatus fromInt(int value) {
            TwoPhaseStatus status = VALUE_MAP.get(value);
            if (status == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid two phase status value: %d", value));
            }
            return status;
        }

        static {
            VALUE_MAP = Arrays.stream(TwoPhaseStatus.values()).collect(Collectors.toUnmodifiableMap(status -> status.value, Function.identity()));
        }
    }
}

