/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.neuralsearch.query.HybridQueryDocIdStream;
import org.opensearch.neuralsearch.query.HybridSubQueryScorer;

public class HybridBulkScorer
extends BulkScorer {
    private static final int SHIFT = 12;
    private static final int WINDOW_SIZE = 4096;
    private static final int MASK = 4095;
    private final long cost;
    private final Scorer[] scorers;
    private final HybridSubQueryScorer hybridSubQueryScorer;
    private final boolean needsScores;
    private final FixedBitSet matching;
    private final float[][] windowScores;
    private final HybridQueryDocIdStream hybridQueryDocIdStream;
    private final int maxDoc;
    private int[] docIds;

    public HybridBulkScorer(List<Scorer> scorers, boolean needsScores, int maxDoc) {
        long cost = 0L;
        int numOfQueries = scorers.size();
        this.scorers = new Scorer[numOfQueries];
        for (int subQueryIndex = 0; subQueryIndex < numOfQueries; ++subQueryIndex) {
            Scorer scorer = scorers.get(subQueryIndex);
            if (Objects.isNull(scorer)) continue;
            cost += scorer.iterator().cost();
            this.scorers[subQueryIndex] = scorer;
        }
        this.cost = cost;
        this.hybridSubQueryScorer = new HybridSubQueryScorer(numOfQueries);
        this.needsScores = needsScores;
        this.matching = new FixedBitSet(4096);
        this.windowScores = new float[this.scorers.length][4096];
        this.maxDoc = maxDoc;
        this.hybridQueryDocIdStream = new HybridQueryDocIdStream(this);
        this.docIds = new int[numOfQueries];
        Arrays.fill(this.docIds, Integer.MAX_VALUE);
    }

    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        collector.setScorer((Scorable)this.hybridSubQueryScorer);
        max = Math.min(max, this.maxDoc);
        this.advance(min, this.scorers);
        while (!this.allDocIdsUsed(this.docIds, max)) {
            this.scoreWindow(collector, acceptDocs, min, max, this.docIds);
        }
        return this.getNextDocIdCandidate(this.docIds);
    }

    private void scoreWindow(LeafCollector collector, Bits acceptDocs, int min, int max, int[] docIds) throws IOException {
        int topDoc = -1;
        for (int docId : docIds) {
            if (docId >= max) continue;
            topDoc = docId;
            break;
        }
        int windowBase = topDoc & 0xFFFFF000;
        int windowMin = Math.max(min, windowBase);
        int windowMax = Math.min(max, windowBase + 4096);
        this.scoreWindowIntoBitSetWithSubqueryScorers(collector, acceptDocs, max, docIds, windowMin, windowMax, windowBase);
    }

    private void scoreWindowIntoBitSetWithSubqueryScorers(LeafCollector collector, Bits acceptDocs, int max, int[] docIds, int windowMin, int windowMax, int windowBase) throws IOException {
        for (int subQueryIndex = 0; subQueryIndex < this.scorers.length; ++subQueryIndex) {
            if (Objects.isNull(this.scorers[subQueryIndex]) || docIds[subQueryIndex] >= max) continue;
            DocIdSetIterator it = this.scorers[subQueryIndex].iterator();
            int doc = docIds[subQueryIndex];
            if (doc < windowMin) {
                doc = it.advance(windowMin);
            }
            while (doc < windowMax) {
                if (Objects.isNull(acceptDocs) || acceptDocs.get(doc)) {
                    int d = doc & 0xFFF;
                    if (this.needsScores) {
                        float score = this.scorers[subQueryIndex].score();
                        if (score > this.hybridSubQueryScorer.getMinScores()[subQueryIndex]) {
                            this.matching.set(d);
                            this.windowScores[subQueryIndex][d] = score;
                        }
                    } else {
                        this.matching.set(d);
                    }
                }
                doc = it.nextDoc();
            }
            docIds[subQueryIndex] = doc;
        }
        this.hybridQueryDocIdStream.setBase(windowBase);
        collector.collect((DocIdStream)this.hybridQueryDocIdStream);
        this.resetWindowState();
    }

    private void advance(int min, Scorer[] scorers) throws IOException {
        for (int subQueryIndex = 0; subQueryIndex < scorers.length; ++subQueryIndex) {
            if (Objects.isNull(scorers[subQueryIndex])) continue;
            DocIdSetIterator it = scorers[subQueryIndex].iterator();
            int doc = it.docID();
            if (doc < min) {
                doc = it.advance(min);
            }
            this.docIds[subQueryIndex] = doc;
        }
    }

    private boolean allDocIdsUsed(int[] docsIds, int max) {
        for (int docId : docsIds) {
            if (docId >= max) continue;
            return false;
        }
        return true;
    }

    private int getNextDocIdCandidate(int[] docsIds) {
        int nextDoc = -1;
        for (int doc : docsIds) {
            if (doc == Integer.MAX_VALUE) continue;
            nextDoc = Math.max(nextDoc, doc);
        }
        return nextDoc == -1 ? Integer.MAX_VALUE : nextDoc;
    }

    private void resetWindowState() {
        this.matching.clear();
        for (float[] windowScore : this.windowScores) {
            Arrays.fill(windowScore, 0.0f);
        }
    }

    public long cost() {
        return this.cost;
    }

    @Generated
    public HybridSubQueryScorer getHybridSubQueryScorer() {
        return this.hybridSubQueryScorer;
    }

    @Generated
    public FixedBitSet getMatching() {
        return this.matching;
    }

    @Generated
    public float[][] getWindowScores() {
        return this.windowScores;
    }

    @Generated
    public int getMaxDoc() {
        return this.maxDoc;
    }
}

