/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.neuralsearch.processor.chunker.Chunker;
import org.opensearch.neuralsearch.processor.chunker.ChunkerParameterParser;
import reactor.util.annotation.NonNull;

public class ChunkUtils {
    public static List<String> chunkString(@NonNull Chunker chunker, String content, Map<String, Object> runTimeParameters) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return List.of();
        }
        List<String> contentResult = chunker.chunk(content, runTimeParameters);
        int chunkStringCount = ChunkerParameterParser.parseInteger(runTimeParameters, Chunker.CHUNK_STRING_COUNT_FIELD);
        runTimeParameters.put(Chunker.CHUNK_STRING_COUNT_FIELD, chunkStringCount - 1);
        int runtimeMaxChunkLimit = ChunkerParameterParser.parseInteger(runTimeParameters, Chunker.MAX_CHUNK_LIMIT_FIELD);
        if (runtimeMaxChunkLimit != Chunker.DISABLED_MAX_CHUNK_LIMIT) {
            runTimeParameters.put(Chunker.MAX_CHUNK_LIMIT_FIELD, runtimeMaxChunkLimit - contentResult.size());
        }
        return contentResult;
    }

    public static List<String> chunkList(@NonNull Chunker chunker, List<String> contentList, Map<String, Object> runTimeParameters) {
        ArrayList<String> result = new ArrayList<String>();
        for (String content : contentList) {
            result.addAll(ChunkUtils.chunkString(chunker, content, runTimeParameters));
        }
        return result;
    }
}

