"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expectOkResult = exports.expectErrorResult = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Useful for asserting results are okay, while still having access to error information. A context
 * object can be supplied to help provide context if the value of the result doesn't contain enough
 * information to know what went wrong.
 */
const expectOkResult = (result, context) => {
  const labeled = {
    ...result,
    context
  };
  expect(labeled).toEqual({
    ok: true,
    context,
    value: expect.anything()
  });
};

/**
 * Validate an error result is correctly returned. A context object can be supplied to help provide
 * context if the value of the result doesn't contain enough information to know what went wrong.
 */
exports.expectOkResult = expectOkResult;
const expectErrorResult = (result, context) => {
  const labeled = {
    ...result,
    context
  };
  expect(labeled).toEqual({
    ok: false,
    context,
    error: expect.anything()
  });
};
exports.expectErrorResult = expectErrorResult;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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