"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _objType = _interopRequireDefault(require("./objType"));

var _JSONObjectNode = _interopRequireDefault(require("./JSONObjectNode"));

var _JSONArrayNode = _interopRequireDefault(require("./JSONArrayNode"));

var _JSONIterableNode = _interopRequireDefault(require("./JSONIterableNode"));

var _JSONValueNode = _interopRequireDefault(require("./JSONValueNode"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var JSONNode = function JSONNode(_ref) {
  var getItemString = _ref.getItemString,
      keyPath = _ref.keyPath,
      labelRenderer = _ref.labelRenderer,
      styling = _ref.styling,
      value = _ref.value,
      valueRenderer = _ref.valueRenderer,
      isCustomNode = _ref.isCustomNode,
      rest = _objectWithoutProperties(_ref, ["getItemString", "keyPath", "labelRenderer", "styling", "value", "valueRenderer", "isCustomNode"]);

  var nodeType = isCustomNode(value) ? 'Custom' : (0, _objType["default"])(value);
  var simpleNodeProps = {
    getItemString: getItemString,
    key: keyPath[0],
    keyPath: keyPath,
    labelRenderer: labelRenderer,
    nodeType: nodeType,
    styling: styling,
    value: value,
    valueRenderer: valueRenderer
  };

  var nestedNodeProps = _objectSpread(_objectSpread(_objectSpread({}, rest), simpleNodeProps), {}, {
    data: value,
    isCustomNode: isCustomNode
  });

  switch (nodeType) {
    case 'Object':
    case 'Error':
    case 'WeakMap':
    case 'WeakSet':
      return /*#__PURE__*/_react["default"].createElement(_JSONObjectNode["default"], nestedNodeProps);

    case 'Array':
      return /*#__PURE__*/_react["default"].createElement(_JSONArrayNode["default"], nestedNodeProps);

    case 'Iterable':
    case 'Map':
    case 'Set':
      return /*#__PURE__*/_react["default"].createElement(_JSONIterableNode["default"], nestedNodeProps);

    case 'String':
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], _extends({}, simpleNodeProps, {
        valueGetter: function valueGetter(raw) {
          return "\"".concat(raw, "\"");
        }
      }));

    case 'Number':
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], simpleNodeProps);

    case 'Boolean':
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], _extends({}, simpleNodeProps, {
        valueGetter: function valueGetter(raw) {
          return raw ? 'true' : 'false';
        }
      }));

    case 'Date':
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], _extends({}, simpleNodeProps, {
        valueGetter: function valueGetter(raw) {
          return raw.toISOString();
        }
      }));

    case 'Null':
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], _extends({}, simpleNodeProps, {
        valueGetter: function valueGetter() {
          return 'null';
        }
      }));

    case 'Undefined':
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], _extends({}, simpleNodeProps, {
        valueGetter: function valueGetter() {
          return 'undefined';
        }
      }));

    case 'Function':
    case 'Symbol':
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], _extends({}, simpleNodeProps, {
        valueGetter: function valueGetter(raw) {
          return raw.toString();
        }
      }));

    case 'Custom':
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], simpleNodeProps);

    default:
      return /*#__PURE__*/_react["default"].createElement(_JSONValueNode["default"], _extends({}, simpleNodeProps, {
        valueGetter: function valueGetter() {
          return "<".concat(nodeType, ">");
        }
      }));
  }
};

JSONNode.propTypes = {
  getItemString: _propTypes["default"].func.isRequired,
  keyPath: _propTypes["default"].arrayOf(_propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number])).isRequired,
  labelRenderer: _propTypes["default"].func.isRequired,
  styling: _propTypes["default"].func.isRequired,
  value: _propTypes["default"].any,
  valueRenderer: _propTypes["default"].func.isRequired,
  isCustomNode: _propTypes["default"].func.isRequired
};
var _default = JSONNode;
exports["default"] = _default;