"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromptBuffer = exports.Prompt = void 0;
const React = __importStar(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
/**
 * Generate what text goes inside the prompt based on the props to the prompt
 */
function promptText(props) {
    if (props.running) {
        return "[*]";
    }
    if (props.queued) {
        return "[…]";
    }
    if (typeof props.counter === "number") {
        return `[${props.counter}]`;
    }
    if (props.blank) {
        return "";
    }
    return "[ ]";
}
const BarePrompt = (props) => {
    return React.createElement("div", { className: props.className }, promptText(props));
};
exports.Prompt = styled_components_1.default(BarePrompt) `
  font-family: monospace;
  font-size: 12px;
  line-height: 22px;
  /* For creating a buffer area for <Prompt blank /> */
  min-height: 22px;

  padding: 9px 0;

  text-align: center;

  color: var(--theme-cell-prompt-fg, black);
  background-color: var(--theme-cell-prompt-bg, #fafafa);
`;
exports.Prompt.defaultProps = {
    counter: null,
    running: false,
    queued: false,
    blank: false,
};
exports.Prompt.displayName = "Prompt";
exports.PromptBuffer = styled_components_1.default(exports.Prompt) ``;
exports.PromptBuffer.defaultProps = {
    blank: true,
};
exports.default = exports.Prompt;
//# sourceMappingURL=prompt.js.map