"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const ImageStyle = styled_components_1.default.img `
  display: block;
  max-width: 100%;
`;
function Image(props) {
    let size = {};
    if (props.metadata) {
        const { width, height } = props.metadata;
        size = { width, height };
    }
    return (react_1.default.createElement(ImageStyle, Object.assign({ alt: "", src: `data:${props.mediaType};base64,${props.data}` }, size)));
}
exports.Image = Image;
Image.defaultProps = {
    data: "",
    mediaType: "image/jpeg"
};
exports.default = Image;
