/// <reference types="react" />
import { ImmutableDisplayData } from "@nteract/commutable";
import { RichMediaProps } from "./rich-media";
interface Props {
    /**
     * The literal type of output, used for routing with the `<Output />` element
     */
    output_type: "display_data";
    output: ImmutableDisplayData;
    /**
     * React elements that accept media bundle data, will get passed `data[mediaType]`
     */
    children: RichMediaProps["children"];
}
export declare const DisplayData: {
    (props: Props): JSX.Element | null;
    defaultProps: {
        output_type: string;
        output: null;
    };
};
export default DisplayData;
