"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternManagementPlugin = void 0;
var _ismPlugin = _interopRequireDefault(require("./clusters/ism/ismPlugin"));
var _services = require("./services");
var _routes = require("../server/routes");
var _dataStreams = _interopRequireDefault(require("./routes/dataStreams"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class IndexPatternManagementPlugin {
  async setup(core, {
    dataSource
  }) {
    // create OpenSearch client that aware of ISM API endpoints
    const osDriver = core.opensearch.legacy.createClient("index_management", {
      plugins: [_ismPlugin.default]
    });
    const dataSourceEnabled = !!dataSource;

    // Initialize services
    const indexService = new _services.IndexService(osDriver, dataSourceEnabled);
    const dataStreamService = new _services.DataStreamService(osDriver, dataSourceEnabled);
    const policyService = new _services.PolicyService(osDriver, dataSourceEnabled);
    const managedIndexService = new _services.ManagedIndexService(osDriver, dataSourceEnabled);
    const rollupService = new _services.RollupService(osDriver, dataSourceEnabled);
    const transformService = new _services.TransformService(osDriver, dataSourceEnabled);
    const notificationService = new _services.NotificationService(osDriver, dataSourceEnabled);
    const snapshotManagementService = new _services.SnapshotManagementService(osDriver, dataSourceEnabled);
    const commonService = new _services.CommonService(osDriver, dataSourceEnabled);
    const aliasService = new _services.AliasServices(osDriver, dataSourceEnabled);
    const services = {
      indexService,
      dataStreamService,
      policyService,
      managedIndexService,
      rollupService,
      transformService,
      notificationService,
      snapshotManagementService,
      commonService,
      aliasService
    };
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_ismPlugin.default);
    }

    // create router
    const router = core.http.createRouter();

    // Add server routes
    (0, _routes.indices)(services, router, dataSourceEnabled);
    (0, _dataStreams.default)(services, router, dataSourceEnabled);
    (0, _routes.policies)(services, router, dataSourceEnabled);
    (0, _routes.managedIndices)(services, router, dataSourceEnabled);
    (0, _routes.rollups)(services, router, dataSourceEnabled);
    (0, _routes.transforms)(services, router, dataSourceEnabled);
    (0, _routes.notifications)(services, router, dataSourceEnabled);
    (0, _routes.snapshotManagement)(services, router, dataSourceEnabled);
    (0, _routes.common)(services, router, dataSourceEnabled);
    (0, _routes.aliases)(services, router, dataSourceEnabled);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.IndexPatternManagementPlugin = IndexPatternManagementPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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