/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.util.DisposeListener;
import com.sun.star.lib.util.DisposeNotifier;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class WeakMap<K, V>
implements Map {
    private final HashMap<K, WeakReference<V>> map = new HashMap();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public WeakMap() {
    }

    public WeakMap(Map<K, V> map) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public WeakReference<V> get(Object object) {
        return this.map.get(object);
    }

    public Object put(Object object, Object object2) {
        this.cleanUp();
        return this.map.put(object, new Entry(object, object2, this.queue));
    }

    public Object remove(Object object) {
        this.cleanUp();
        return this.map.remove(object);
    }

    public void putAll(Map map) {
        this.cleanUp();
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            this.map.put(k, new Entry(k, entry.getValue(), this.queue));
        }
    }

    @Override
    public void clear() {
        this.cleanUp();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<WeakReference<V>> values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public static <T> T getValue(Object object) {
        return object == null ? null : (T)((WeakReference)object).get();
    }

    private void cleanUp() {
        Entry entry;
        while ((entry = (Entry)this.queue.poll()) != null) {
            Object object = entry.key;
            if (entry != this.map.get(object)) continue;
            this.map.remove(object);
        }
    }

    private static final class Entry<K, V>
    extends WeakReference<V>
    implements DisposeListener {
        private final K key;

        private Entry(K k, V v, ReferenceQueue<V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
            if (v instanceof DisposeNotifier) {
                ((DisposeNotifier)v).addDisposeListener(this);
            }
        }

        @Override
        public void notifyDispose(DisposeNotifier disposeNotifier) {
            this.clear();
            this.enqueue();
        }
    }
}

