/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchFileReader
implements Iterator<BatchAndType>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(BatchFileReader.class);
    private final FileRecords fileRecords;
    private Iterator<FileLogInputStream.FileChannelRecordBatch> batchIterator;
    private final MetadataRecordSerde serde;

    private BatchFileReader(FileRecords fileRecords) {
        this.fileRecords = fileRecords;
        this.batchIterator = fileRecords.batchIterator();
        this.serde = new MetadataRecordSerde();
    }

    @Override
    public boolean hasNext() {
        return this.batchIterator.hasNext();
    }

    @Override
    public BatchAndType next() {
        FileLogInputStream.FileChannelRecordBatch input = this.batchIterator.next();
        if (input.isControlBatch()) {
            return this.nextControlBatch(input);
        }
        return this.nextDataBatch(input);
    }

    private BatchAndType nextControlBatch(FileLogInputStream.FileChannelRecordBatch input) {
        ArrayList<ApiMessageAndVersion> messages = new ArrayList<ApiMessageAndVersion>();
        for (Record record : input) {
            try {
                short typeId = ControlRecordType.parseTypeId((ByteBuffer)record.key());
                ControlRecordType type = ControlRecordType.fromTypeId((short)typeId);
                switch (type) {
                    case LEADER_CHANGE: {
                        LeaderChangeMessage message = new LeaderChangeMessage();
                        message.read((Readable)new ByteBufferAccessor(record.value()), (short)0);
                        messages.add(new ApiMessageAndVersion((ApiMessage)message, 0));
                        break;
                    }
                    case SNAPSHOT_HEADER: {
                        LeaderChangeMessage message = new SnapshotHeaderRecord();
                        message.read((Readable)new ByteBufferAccessor(record.value()), (short)0);
                        messages.add(new ApiMessageAndVersion((ApiMessage)message, 0));
                        break;
                    }
                    case SNAPSHOT_FOOTER: {
                        LeaderChangeMessage message = new SnapshotFooterRecord();
                        message.read((Readable)new ByteBufferAccessor(record.value()), (short)0);
                        messages.add(new ApiMessageAndVersion((ApiMessage)message, 0));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported control record type " + String.valueOf(type) + " at offset " + record.offset());
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to read control record at offset " + record.offset(), e);
            }
        }
        return new BatchAndType((Batch<ApiMessageAndVersion>)Batch.data((long)input.baseOffset(), (int)input.partitionLeaderEpoch(), (long)input.maxTimestamp(), (int)input.sizeInBytes(), messages), true);
    }

    private BatchAndType nextDataBatch(FileLogInputStream.FileChannelRecordBatch input) {
        ArrayList<ApiMessageAndVersion> messages = new ArrayList<ApiMessageAndVersion>();
        for (Record record : input) {
            try {
                ByteBufferAccessor accessor = new ByteBufferAccessor(record.value());
                ApiMessageAndVersion messageAndVersion = this.serde.read((Readable)accessor, record.valueSize());
                messages.add(messageAndVersion);
            }
            catch (Throwable e) {
                throw new RuntimeException("unable to deserialize record at offset " + record.offset(), e);
            }
        }
        return new BatchAndType((Batch<ApiMessageAndVersion>)Batch.data((long)input.baseOffset(), (int)input.partitionLeaderEpoch(), (long)input.maxTimestamp(), (int)input.sizeInBytes(), messages), false);
    }

    @Override
    public void close() {
        try {
            this.fileRecords.closeHandlers();
        }
        catch (Exception e) {
            log.error("Error closing fileRecords", (Throwable)e);
        }
        this.batchIterator = Collections.emptyIterator();
    }

    public static class BatchAndType {
        private final Batch<ApiMessageAndVersion> batch;
        private final boolean isControl;

        public BatchAndType(Batch<ApiMessageAndVersion> batch, boolean isControl) {
            this.batch = batch;
            this.isControl = isControl;
        }

        public Batch<ApiMessageAndVersion> batch() {
            return this.batch;
        }

        public boolean isControl() {
            return this.isControl;
        }
    }

    public static class Builder {
        private String path = null;

        public Builder setPath(String path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public BatchFileReader build() throws Exception {
            if (this.path == null) {
                throw new RuntimeException("You must specify a path.");
            }
            FileRecords fileRecords = FileRecords.open((File)new File(this.path), (boolean)false);
            try {
                return new BatchFileReader(fileRecords);
            }
            catch (Throwable e) {
                Utils.closeQuietly((AutoCloseable)fileRecords, (String)"fileRecords");
                throw e;
            }
        }
    }
}

