/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.BalanceSubtopologyGraphConstructor;
import org.apache.kafka.streams.processor.internals.assignment.MinTrafficGraphConstructor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareGraphConstructor;

public class RackAwareGraphConstructorFactory {
    static <T> RackAwareGraphConstructor<T> create(AssignmentConfigs assignmentConfigs, Map<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup) {
        return RackAwareGraphConstructorFactory.create(assignmentConfigs.rackAwareAssignmentStrategy(), new ArrayList<Set<TaskId>>(new TreeMap<TopologyMetadata.Subtopology, Set<TaskId>>(tasksForTopicGroup).values()));
    }

    public static <T> RackAwareGraphConstructor<T> create(String rackAwareAssignmentStrategy, Collection<TaskId> allTasks) {
        TreeMap<Integer, Set> tasksForTopologyId = new TreeMap<Integer, Set>();
        allTasks.forEach(taskId -> {
            tasksForTopologyId.computeIfAbsent(taskId.subtopology(), k -> new HashSet());
            ((Set)tasksForTopologyId.get(taskId.subtopology())).add(taskId);
        });
        ArrayList<Set<TaskId>> tasksForTopicGroup = new ArrayList<Set<TaskId>>();
        tasksForTopologyId.forEach((subtopology, taskIds) -> tasksForTopicGroup.add((Set<TaskId>)taskIds));
        return RackAwareGraphConstructorFactory.create(rackAwareAssignmentStrategy, tasksForTopicGroup);
    }

    public static <T> RackAwareGraphConstructor<T> create(String rackAwareAssignmentStrategy, List<Set<TaskId>> taskSetsPerTopicGroup) {
        switch (rackAwareAssignmentStrategy) {
            case "min_traffic": {
                return new MinTrafficGraphConstructor();
            }
            case "balance_subtopology": {
                return new BalanceSubtopologyGraphConstructor(taskSetsPerTopicGroup);
            }
        }
        throw new IllegalArgumentException("Rack aware assignment is disabled");
    }
}

