/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.TransformationStage;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.errors.ToleranceType;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.isolation.PluginsRecommenders;
import org.apache.kafka.connect.runtime.isolation.VersionedPluginLoadingException;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.apache.kafka.connect.util.ConcreteSubClassValidator;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.InstantiableClassValidator;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(ConnectorConfig.class);
    protected static final String COMMON_GROUP = "Common";
    protected static final String TRANSFORMS_GROUP = "Transforms";
    protected static final String PREDICATES_GROUP = "Predicates";
    protected static final String ERROR_GROUP = "Error Handling";
    public static final String NAME_CONFIG = "name";
    private static final String NAME_DOC = "Globally unique name to use for this connector.";
    private static final String NAME_DISPLAY = "Connector name";
    public static final String CONNECTOR_CLASS_CONFIG = "connector.class";
    private static final String CONNECTOR_CLASS_DOC = "Name or alias of the class for this connector. Must be a subclass of org.apache.kafka.connect.connector.Connector. If the connector is org.apache.kafka.connect.file.FileStreamSinkConnector, you can either specify this full name,  or use \"FileStreamSink\" or \"FileStreamSinkConnector\" to make the configuration a bit shorter";
    private static final String CONNECTOR_CLASS_DISPLAY = "Connector class";
    public static final String CONNECTOR_VERSION = "connector.plugin.version";
    private static final String CONNECTOR_VERSION_DOC = "Version of the connector.";
    private static final String CONNECTOR_VERSION_DISPLAY = "Connector version";
    private static final ConfigDef.Validator CONNECTOR_VERSION_VALIDATOR = new PluginVersionValidator();
    public static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    public static final String KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String KEY_CONVERTER_CLASS_DISPLAY = "Key converter class";
    private static final ConfigDef.Validator KEY_CONVERTER_CLASS_VALIDATOR = ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{ConcreteSubClassValidator.forSuperClass(Converter.class), new InstantiableClassValidator()});
    public static final String KEY_CONVERTER_VERSION_CONFIG = "key.converter.plugin.version";
    private static final String KEY_CONVERTER_VERSION_DOC = "Version of the key converter.";
    private static final String KEY_CONVERTER_VERSION_DISPLAY = "Key converter version";
    private static final ConfigDef.Validator KEY_CONVERTER_VERSION_VALIDATOR = new PluginVersionValidator();
    public static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    public static final String VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String VALUE_CONVERTER_CLASS_DISPLAY = "Value converter class";
    private static final ConfigDef.Validator VALUE_CONVERTER_CLASS_VALIDATOR = ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{ConcreteSubClassValidator.forSuperClass(Converter.class), new InstantiableClassValidator()});
    public static final String VALUE_CONVERTER_VERSION_CONFIG = "value.converter.plugin.version";
    private static final String VALUE_CONVERTER_VERSION_DOC = "Version of the value converter.";
    private static final String VALUE_CONVERTER_VERSION_DISPLAY = "Value converter version";
    private static final ConfigDef.Validator VALUE_CONVERTER_VERSION_VALIDATOR = new PluginVersionValidator();
    public static final String HEADER_CONVERTER_CLASS_CONFIG = "header.converter";
    public static final String HEADER_CONVERTER_CLASS_DOC = "HeaderConverter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the header values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro. By default, the SimpleHeaderConverter is used to serialize header values to strings and deserialize them by inferring the schemas.";
    public static final String HEADER_CONVERTER_CLASS_DISPLAY = "Header converter class";
    private static final ConfigDef.Validator HEADER_CONVERTER_CLASS_VALIDATOR = ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{ConcreteSubClassValidator.forSuperClass(HeaderConverter.class), new InstantiableClassValidator()});
    public static final String HEADER_CONVERTER_VERSION_CONFIG = "header.converter.plugin.version";
    private static final String HEADER_CONVERTER_VERSION_DOC = "Version of the header converter.";
    private static final String HEADER_CONVERTER_VERSION_DISPLAY = "Header converter version";
    private static final ConfigDef.Validator HEADER_CONVERTER_VERSION_VALIDATOR = new PluginVersionValidator();
    public static final String TASKS_MAX_CONFIG = "tasks.max";
    private static final String TASKS_MAX_DOC = "Maximum number of tasks to use for this connector.";
    public static final int TASKS_MAX_DEFAULT = 1;
    private static final int TASKS_MIN_CONFIG = 1;
    private static final String TASK_MAX_DISPLAY = "Tasks max";
    public static final String TASKS_MAX_ENFORCE_CONFIG = "tasks.max.enforce";
    private static final String TASKS_MAX_ENFORCE_DOC = "(Deprecated) Whether to enforce that the tasks.max property is respected by the connector. By default, connectors that generate too many tasks will fail, and existing sets of tasks that exceed the tasks.max property will also be failed. If this property is set to false, then connectors will be allowed to generate more than the maximum number of tasks, and existing sets of tasks that exceed the tasks.max property will be allowed to run. This property is deprecated and will be removed in an upcoming major release.";
    public static final boolean TASKS_MAX_ENFORCE_DEFAULT = true;
    private static final String TASKS_MAX_ENFORCE_DISPLAY = "Enforce tasks max";
    public static final String TRANSFORMS_CONFIG = "transforms";
    private static final String TRANSFORMS_DOC = "Aliases for the transformations to be applied to records.";
    private static final String TRANSFORMS_DISPLAY = "Transforms";
    public static final String PREDICATES_CONFIG = "predicates";
    private static final String PREDICATES_DOC = "Aliases for the predicates used by transformations.";
    private static final String PREDICATES_DISPLAY = "Predicates";
    public static final String CONFIG_RELOAD_ACTION_CONFIG = "config.action.reload";
    private static final String CONFIG_RELOAD_ACTION_DOC = "The action that Connect should take on the connector when changes in external configuration providers result in a change in the connector's configuration properties. A value of 'none' indicates that Connect will do nothing. A value of 'restart' indicates that Connect should restart/reload the connector with the updated configuration properties.The restart may actually be scheduled in the future if the external configuration provider indicates that a configuration value will expire in the future.";
    private static final String CONFIG_RELOAD_ACTION_DISPLAY = "Reload Action";
    public static final String CONFIG_RELOAD_ACTION_NONE = Herder.ConfigReloadAction.NONE.name().toLowerCase(Locale.ROOT);
    public static final String CONFIG_RELOAD_ACTION_RESTART = Herder.ConfigReloadAction.RESTART.name().toLowerCase(Locale.ROOT);
    public static final String ERRORS_RETRY_TIMEOUT_CONFIG = "errors.retry.timeout";
    public static final String ERRORS_RETRY_TIMEOUT_DISPLAY = "Retry Timeout for Errors";
    public static final int ERRORS_RETRY_TIMEOUT_DEFAULT = 0;
    public static final String ERRORS_RETRY_TIMEOUT_DOC = "The maximum duration in milliseconds that a failed operation will be reattempted. The default is 0, which means no retries will be attempted. Use -1 for infinite retries.";
    public static final String ERRORS_RETRY_MAX_DELAY_CONFIG = "errors.retry.delay.max.ms";
    public static final String ERRORS_RETRY_MAX_DELAY_DISPLAY = "Maximum Delay Between Retries for Errors";
    public static final int ERRORS_RETRY_MAX_DELAY_DEFAULT = 60000;
    public static final String ERRORS_RETRY_MAX_DELAY_DOC = "The maximum duration in milliseconds between consecutive retry attempts. Jitter will be added to the delay once this limit is reached to prevent thundering herd issues.";
    public static final String ERRORS_TOLERANCE_CONFIG = "errors.tolerance";
    public static final String ERRORS_TOLERANCE_DISPLAY = "Error Tolerance";
    public static final ToleranceType ERRORS_TOLERANCE_DEFAULT = ToleranceType.NONE;
    public static final String ERRORS_TOLERANCE_DOC = "Behavior for tolerating errors during connector operation. 'none' is the default value and signals that any error will result in an immediate connector task failure; 'all' changes the behavior to skip over problematic records.";
    public static final String ERRORS_LOG_ENABLE_CONFIG = "errors.log.enable";
    public static final String ERRORS_LOG_ENABLE_DISPLAY = "Log Errors";
    public static final boolean ERRORS_LOG_ENABLE_DEFAULT = false;
    public static final String ERRORS_LOG_ENABLE_DOC = "If true, write each error and the details of the failed operation and problematic record to the Connect application log. This is 'false' by default, so that only errors that are not tolerated are reported.";
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_CONFIG = "errors.log.include.messages";
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_DISPLAY = "Log Error Details";
    public static final boolean ERRORS_LOG_INCLUDE_MESSAGES_DEFAULT = false;
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_DOC = "Whether to include in the log the Connect record that resulted in a failure. For sink records, the topic, partition, offset, and timestamp will be logged. For source records, the key and value (and their schemas), all headers, and the timestamp, Kafka topic, Kafka partition, source partition, and source offset will be logged. This is 'false' by default, which will prevent record keys, values, and headers from being written to log files.";
    public static final String CONNECTOR_CLIENT_PRODUCER_OVERRIDES_PREFIX = "producer.override.";
    public static final String CONNECTOR_CLIENT_CONSUMER_OVERRIDES_PREFIX = "consumer.override.";
    public static final String CONNECTOR_CLIENT_ADMIN_OVERRIDES_PREFIX = "admin.override.";
    public static final String PREDICATES_PREFIX = "predicates.";
    private static final PluginsRecommenders EMPTY_RECOMMENDER = new PluginsRecommenders();
    private static final ConverterDefaults CONVERTER_DEFAULTS = new ConverterDefaults(null, null);
    private final EnrichedConnectorConfig enrichedConfig;

    protected static ConfigDef configDef(String defaultConnectorVersion, ConverterDefaults keyConverterDefaults, ConverterDefaults valueConverterDefaults, ConverterDefaults headerConverterDefaults, PluginsRecommenders recommender) {
        int orderInGroup = 0;
        int orderInErrorGroup = 0;
        return new ConfigDef().define(NAME_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.NonEmptyStringWithoutControlChars.nonEmptyStringWithoutControlChars(), ConfigDef.Importance.HIGH, NAME_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, NAME_DISPLAY).define(CONNECTOR_CLASS_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, CONNECTOR_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.LONG, CONNECTOR_CLASS_DISPLAY).define(CONNECTOR_VERSION, ConfigDef.Type.STRING, (Object)defaultConnectorVersion, CONNECTOR_VERSION_VALIDATOR, ConfigDef.Importance.MEDIUM, CONNECTOR_VERSION_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, CONNECTOR_VERSION_DISPLAY, (ConfigDef.Recommender)recommender.connectorPluginVersionRecommender()).define(TASKS_MAX_CONFIG, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, TASKS_MAX_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, TASK_MAX_DISPLAY).define(TASKS_MAX_ENFORCE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, TASKS_MAX_ENFORCE_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, TASKS_MAX_ENFORCE_DISPLAY).define(KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)keyConverterDefaults.type, KEY_CONVERTER_CLASS_VALIDATOR, ConfigDef.Importance.LOW, KEY_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, KEY_CONVERTER_CLASS_DISPLAY, (ConfigDef.Recommender)recommender.converterPluginRecommender()).define(KEY_CONVERTER_VERSION_CONFIG, ConfigDef.Type.STRING, (Object)keyConverterDefaults.version, KEY_CONVERTER_VERSION_VALIDATOR, ConfigDef.Importance.LOW, KEY_CONVERTER_VERSION_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, KEY_CONVERTER_VERSION_DISPLAY, (ConfigDef.Recommender)recommender.keyConverterPluginVersionRecommender()).define(VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)valueConverterDefaults.type, VALUE_CONVERTER_CLASS_VALIDATOR, ConfigDef.Importance.LOW, VALUE_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, VALUE_CONVERTER_CLASS_DISPLAY, (ConfigDef.Recommender)recommender.converterPluginRecommender()).define(VALUE_CONVERTER_VERSION_CONFIG, ConfigDef.Type.STRING, (Object)valueConverterDefaults.version, VALUE_CONVERTER_VERSION_VALIDATOR, ConfigDef.Importance.LOW, VALUE_CONVERTER_VERSION_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, VALUE_CONVERTER_VERSION_DISPLAY, (ConfigDef.Recommender)recommender.valueConverterPluginVersionRecommender()).define(HEADER_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)headerConverterDefaults.type, HEADER_CONVERTER_CLASS_VALIDATOR, ConfigDef.Importance.LOW, HEADER_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, HEADER_CONVERTER_CLASS_DISPLAY, (ConfigDef.Recommender)recommender.headerConverterPluginRecommender()).define(HEADER_CONVERTER_VERSION_CONFIG, ConfigDef.Type.STRING, (Object)headerConverterDefaults.version, HEADER_CONVERTER_VERSION_VALIDATOR, ConfigDef.Importance.LOW, HEADER_CONVERTER_VERSION_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, HEADER_CONVERTER_VERSION_DISPLAY, (ConfigDef.Recommender)recommender.headerConverterPluginVersionRecommender()).define(TRANSFORMS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConnectorConfig.aliasValidator("transformation"), ConfigDef.Importance.LOW, TRANSFORMS_DOC, "Transforms", ++orderInGroup, ConfigDef.Width.LONG, "Transforms").define(PREDICATES_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConnectorConfig.aliasValidator("predicate"), ConfigDef.Importance.LOW, PREDICATES_DOC, "Predicates", ++orderInGroup, ConfigDef.Width.LONG, "Predicates").define(CONFIG_RELOAD_ACTION_CONFIG, ConfigDef.Type.STRING, (Object)CONFIG_RELOAD_ACTION_RESTART, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{CONFIG_RELOAD_ACTION_NONE, CONFIG_RELOAD_ACTION_RESTART}), ConfigDef.Importance.LOW, CONFIG_RELOAD_ACTION_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFIG_RELOAD_ACTION_DISPLAY).define(ERRORS_RETRY_TIMEOUT_CONFIG, ConfigDef.Type.LONG, (Object)0, ConfigDef.Importance.MEDIUM, ERRORS_RETRY_TIMEOUT_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.MEDIUM, ERRORS_RETRY_TIMEOUT_DISPLAY).define(ERRORS_RETRY_MAX_DELAY_CONFIG, ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.MEDIUM, ERRORS_RETRY_MAX_DELAY_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.MEDIUM, ERRORS_RETRY_MAX_DELAY_DISPLAY).define(ERRORS_TOLERANCE_CONFIG, ConfigDef.Type.STRING, (Object)ERRORS_TOLERANCE_DEFAULT.value(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ToleranceType.NONE.value(), ToleranceType.ALL.value()}), ConfigDef.Importance.MEDIUM, ERRORS_TOLERANCE_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_TOLERANCE_DISPLAY).define(ERRORS_LOG_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ERRORS_LOG_ENABLE_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_LOG_ENABLE_DISPLAY).define(ERRORS_LOG_INCLUDE_MESSAGES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ERRORS_LOG_INCLUDE_MESSAGES_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_LOG_INCLUDE_MESSAGES_DISPLAY);
    }

    public static ConfigDef configDef() {
        return ConnectorConfig.configDef(null, CONVERTER_DEFAULTS, CONVERTER_DEFAULTS, CONVERTER_DEFAULTS, EMPTY_RECOMMENDER);
    }

    public static ConfigDef enrichedConfigDef(Plugins plugins, Map<String, String> connProps, WorkerConfig workerConfig) {
        PluginsRecommenders recommender = new PluginsRecommenders(plugins);
        ConverterDefaults keyConverterDefaults = ConnectorConfig.converterDefaults(plugins, KEY_CONVERTER_CLASS_CONFIG, KEY_CONVERTER_CLASS_CONFIG, KEY_CONVERTER_VERSION_CONFIG, connProps, workerConfig, PluginType.CONVERTER);
        ConverterDefaults valueConverterDefaults = ConnectorConfig.converterDefaults(plugins, VALUE_CONVERTER_CLASS_CONFIG, VALUE_CONVERTER_CLASS_CONFIG, VALUE_CONVERTER_VERSION_CONFIG, connProps, workerConfig, PluginType.CONVERTER);
        ConverterDefaults headerConverterDefaults = ConnectorConfig.converterDefaults(plugins, HEADER_CONVERTER_CLASS_CONFIG, HEADER_CONVERTER_CLASS_CONFIG, HEADER_CONVERTER_VERSION_CONFIG, connProps, workerConfig, PluginType.HEADER_CONVERTER);
        return ConnectorConfig.configDef(plugins.latestVersion(connProps.get(CONNECTOR_CLASS_CONFIG), PluginType.SINK, PluginType.SOURCE), keyConverterDefaults, valueConverterDefaults, headerConverterDefaults, recommender);
    }

    public static ConfigDef enrichedConfigDef(Plugins plugins, String connectorClass) {
        return ConnectorConfig.configDef(plugins.latestVersion(connectorClass, PluginType.SINK, PluginType.SOURCE), CONVERTER_DEFAULTS, CONVERTER_DEFAULTS, CONVERTER_DEFAULTS, EMPTY_RECOMMENDER);
    }

    private static ConfigDef.CompositeValidator aliasValidator(String kind) {
        return ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{new ConfigDef.NonNullValidator(), ConfigDef.LambdaValidator.with((name, value) -> {
            List aliases = (List)value;
            if (aliases.size() > new HashSet(aliases).size()) {
                throw new ConfigException(name, value, "Duplicate alias provided.");
            }
        }, () -> "unique " + kind + " aliases")});
    }

    public ConnectorConfig(Plugins plugins) {
        this(plugins, Collections.emptyMap());
    }

    public ConnectorConfig(Plugins plugins, Map<String, String> props) {
        this(plugins, ConnectorConfig.configDef(), props);
    }

    public ConnectorConfig(Plugins plugins, ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
        this.enrichedConfig = new EnrichedConnectorConfig(ConnectorConfig.enrich(plugins, configDef, props, true), props);
    }

    public Object get(String key) {
        return this.enrichedConfig.get(key);
    }

    public long errorRetryTimeout() {
        return this.getLong(ERRORS_RETRY_TIMEOUT_CONFIG);
    }

    public long errorMaxDelayInMillis() {
        return this.getLong(ERRORS_RETRY_MAX_DELAY_CONFIG);
    }

    public ToleranceType errorToleranceType() {
        String tolerance = this.getString(ERRORS_TOLERANCE_CONFIG);
        for (ToleranceType type : ToleranceType.values()) {
            if (!type.name().equalsIgnoreCase(tolerance)) continue;
            return type;
        }
        return ERRORS_TOLERANCE_DEFAULT;
    }

    public boolean enableErrorLog() {
        return this.getBoolean(ERRORS_LOG_ENABLE_CONFIG);
    }

    public boolean includeRecordDetailsInErrorLog() {
        return this.getBoolean(ERRORS_LOG_INCLUDE_MESSAGES_CONFIG);
    }

    public int tasksMax() {
        return this.getInt(TASKS_MAX_CONFIG);
    }

    public boolean enforceTasksMax() {
        return this.getBoolean(TASKS_MAX_ENFORCE_CONFIG);
    }

    public <R extends ConnectRecord<R>> List<TransformationStage<R>> transformationStages(Plugins plugins, ConnectorTaskId connectorTaskId, ConnectMetrics metrics) {
        List transformAliases = this.getList(TRANSFORMS_CONFIG);
        ArrayList<TransformationStage<R>> transformations = new ArrayList<TransformationStage<R>>(transformAliases.size());
        for (String alias : transformAliases) {
            String prefix = "transforms." + alias + ".";
            try {
                String typeConfig = prefix + "type";
                String versionConfig = prefix + "plugin.version";
                Transformation transformation = (Transformation)this.getTransformationOrPredicate(plugins, typeConfig, versionConfig);
                Map configs = this.originalsWithPrefix(prefix);
                String predicateAlias = (String)configs.remove("predicate");
                Object negate = configs.remove("negate");
                transformation.configure(configs);
                Plugin transformationPlugin = metrics.wrap(transformation, connectorTaskId, alias);
                if (predicateAlias != null) {
                    String predicatePrefix = PREDICATES_PREFIX + predicateAlias + ".";
                    String predicateTypeConfig = predicatePrefix + "type";
                    String predicateVersionConfig = predicatePrefix + "plugin.version";
                    Predicate predicate = (Predicate)this.getTransformationOrPredicate(plugins, predicateTypeConfig, predicateVersionConfig);
                    predicate.configure(this.originalsWithPrefix(predicatePrefix));
                    Plugin predicatePlugin = metrics.wrap(predicate, connectorTaskId, predicateAlias);
                    transformations.add(new TransformationStage(predicatePlugin, predicateAlias, plugins.pluginVersion(predicate.getClass().getName(), predicate.getClass().getClassLoader(), PluginType.PREDICATE), negate != null && Boolean.parseBoolean(negate.toString()), transformationPlugin, alias, plugins.pluginVersion(transformation.getClass().getName(), transformation.getClass().getClassLoader(), PluginType.TRANSFORMATION), plugins.safeLoaderSwapper()));
                    continue;
                }
                transformations.add(new TransformationStage(transformationPlugin, alias, plugins.pluginVersion(transformation.getClass().getName(), transformation.getClass().getClassLoader(), PluginType.TRANSFORMATION), plugins.safeLoaderSwapper()));
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e);
            }
        }
        return transformations;
    }

    private <T> T getTransformationOrPredicate(Plugins plugins, String classConfig, String versionConfig) {
        try {
            VersionRange range = PluginUtils.connectorVersionRequirement(this.getString(versionConfig));
            VersionRange connectorRange = PluginUtils.connectorVersionRequirement(this.getString(CONNECTOR_VERSION));
            return (T)plugins.newPlugin(this.getClass(classConfig).getName(), range, plugins.connectorLoader(this.getString(CONNECTOR_CLASS_CONFIG), connectorRange));
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public static ConfigDef enrich(final Plugins plugins, ConfigDef baseConfigDef, final Map<String, String> props, boolean requireFullConfig) {
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        new EnrichablePlugin<Transformation<?>>("Transformation", TRANSFORMS_CONFIG, "Transforms", PluginType.TRANSFORMATION, props, requireFullConfig){

            @Override
            protected Set<PluginDesc<Transformation<?>>> plugins() {
                return plugins.transformations();
            }

            @Override
            protected ConfigDef initialConfigDef() {
                return super.initialConfigDef().define("predicate", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The alias of a predicate used to determine whether to apply this transformation.").define("negate", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether the configured predicate should be negated.");
            }

            @Override
            protected Stream<Map.Entry<String, ConfigDef.ConfigKey>> configDefsForClass(String typeConfig, String versionConfig, Plugins plugins2) {
                return super.configDefsForClass(typeConfig, versionConfig, plugins2).filter(entry -> {
                    if ("predicate".equals(entry.getKey()) || "negate".equals(entry.getKey())) {
                        log.warn("Transformer config {} is masked by implicit config of that name", entry.getKey());
                        return false;
                    }
                    return true;
                });
            }

            @Override
            protected ConfigDef config(Transformation<?> transformation) {
                return transformation.config();
            }

            @Override
            protected void validateProps(String prefix) {
                String prefixedNegate = prefix + "negate";
                String prefixedPredicate = prefix + "predicate";
                if (props.containsKey(prefixedNegate) && !props.containsKey(prefixedPredicate)) {
                    throw new ConfigException("Config '" + prefixedNegate + "' was provided but there is no config '" + prefixedPredicate + "' defining a predicate to be negated.");
                }
            }

            @Override
            protected ConfigDef.Recommender versionRecommender(String typeConfig) {
                return new PluginsRecommenders(plugins).transformationPluginRecommender(typeConfig);
            }
        }.enrich(newDef, plugins);
        new EnrichablePlugin<Predicate<?>>("Predicate", PREDICATES_CONFIG, "Predicates", PluginType.PREDICATE, props, requireFullConfig){

            @Override
            protected Set<PluginDesc<Predicate<?>>> plugins() {
                return plugins.predicates();
            }

            @Override
            protected ConfigDef config(Predicate<?> predicate) {
                return predicate.config();
            }

            @Override
            protected ConfigDef.Recommender versionRecommender(String typeConfig) {
                return new PluginsRecommenders(plugins).predicatePluginRecommender(typeConfig);
            }
        }.enrich(newDef, plugins);
        return newDef;
    }

    private static <T> ConverterDefaults converterDefaults(Plugins plugins, String connectorConverterConfig, String workerConverterConfig, String workerConverterVersionConfig, Map<String, String> connectorProps, WorkerConfig workerConfig, PluginType converterType) {
        String connectorConverter = connectorProps.get(connectorConverterConfig);
        String workerConverter = workerConverterConfig.equals(HEADER_CONVERTER_CLASS_CONFIG) ? workerConfig.getClass(workerConverterConfig).getName() : (String)workerConfig.originalsStrings().get(workerConverterConfig);
        String connectorClass = connectorProps.get(CONNECTOR_CLASS_CONFIG);
        String connectorVersion = connectorProps.get(CONNECTOR_VERSION);
        String type = null;
        if (connectorClass == null || connectorConverter == null && workerConverter == null) {
            return new ConverterDefaults(null, null);
        }
        type = workerConverter;
        String version = null;
        if (connectorConverter != null) {
            version = ConnectorConfig.fetchPluginVersion(plugins, connectorClass, connectorVersion, connectorConverter, converterType);
        } else {
            version = (String)workerConfig.originalsStrings().get(workerConverterVersionConfig);
            if (version == null) {
                version = plugins.latestVersion(workerConverter, converterType);
            }
        }
        return new ConverterDefaults(type, version);
    }

    private static <T> String fetchPluginVersion(Plugins plugins, String connectorClass, String connectorVersion, String pluginName, PluginType pluginType) {
        if (pluginName == null || connectorClass == null) {
            return null;
        }
        try {
            VersionRange range = PluginUtils.connectorVersionRequirement(connectorVersion);
            return plugins.pluginVersion(pluginName, plugins.connectorLoader(connectorClass, range), pluginType);
        }
        catch (VersionedPluginLoadingException | InvalidVersionSpecificationException e) {
            log.warn("Failed to determine default plugin version for {}", (Object)connectorClass, e);
            return null;
        }
    }

    private record ConverterDefaults(String type, String version) {
    }

    private static class EnrichedConnectorConfig
    extends AbstractConfig {
        EnrichedConnectorConfig(ConfigDef configDef, Map<String, String> props) {
            super(configDef, props);
        }

        public Object get(String key) {
            return super.get(key);
        }
    }

    public static class PluginVersionValidator
    implements ConfigDef.Validator {
        public void ensureValid(String name, Object value) {
            try {
                PluginUtils.connectorVersionRequirement((String)value);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionedPluginLoadingException(e.getMessage());
            }
        }
    }

    static abstract class EnrichablePlugin<T> {
        private final String aliasKind;
        private final String aliasConfig;
        private final String aliasGroup;
        private final PluginType pluginType;
        private final Class<T> baseClass;
        private final Map<String, String> props;
        private final boolean requireFullConfig;

        public EnrichablePlugin(String aliasKind, String aliasConfig, String aliasGroup, PluginType pluginType, Map<String, String> props, boolean requireFullConfig) {
            this.aliasKind = aliasKind;
            this.aliasConfig = aliasConfig;
            this.aliasGroup = aliasGroup;
            this.pluginType = pluginType;
            this.baseClass = pluginType.superClass();
            this.props = props;
            this.requireFullConfig = requireFullConfig;
        }

        void enrich(ConfigDef newDef, Plugins plugins) {
            Object aliases = ConfigDef.parseType((String)this.aliasConfig, (Object)this.props.get(this.aliasConfig), (ConfigDef.Type)ConfigDef.Type.LIST);
            if (!(aliases instanceof List)) {
                return;
            }
            LinkedHashSet uniqueAliases = new LinkedHashSet((List)aliases);
            for (Object o : uniqueAliases) {
                if (!(o instanceof String)) {
                    throw new ConfigException("Item in " + this.aliasConfig + " property is not of type String");
                }
                String alias = (String)o;
                String prefix = this.aliasConfig + "." + alias + ".";
                String group = this.aliasGroup + ": " + alias;
                int orderInGroup = 0;
                String typeConfig = prefix + "type";
                String versionConfig = prefix + "plugin.version";
                String defaultVersion = ConnectorConfig.fetchPluginVersion(plugins, this.props.get(ConnectorConfig.CONNECTOR_CLASS_CONFIG), this.props.get(ConnectorConfig.CONNECTOR_VERSION), this.props.get(typeConfig), this.pluginType);
                ConfigDef.LambdaValidator typeValidator = ConfigDef.LambdaValidator.with((name, value) -> {
                    this.validateProps(prefix);
                    if (value != null) {
                        this.getConfigDefFromPlugin(typeConfig, ((Class)value).getName(), this.props.getOrDefault(versionConfig, defaultVersion), plugins);
                    }
                }, () -> "valid configs for " + alias + " " + this.aliasKind.toLowerCase(Locale.ENGLISH));
                newDef.define(typeConfig, ConfigDef.Type.CLASS, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)typeValidator, ConfigDef.Importance.HIGH, "Class for the '" + alias + "' " + this.aliasKind.toLowerCase(Locale.ENGLISH) + ".", group, orderInGroup++, ConfigDef.Width.LONG, this.baseClass.getSimpleName() + " type for " + alias, Collections.emptyList(), (ConfigDef.Recommender)new ClassRecommender());
                ConfigDef.Validator versionValidator = (name, value) -> {
                    if (value != null) {
                        try {
                            this.getConfigDefFromPlugin(typeConfig, this.props.get(typeConfig), (String)value, plugins);
                        }
                        catch (VersionedPluginLoadingException e) {
                            throw e;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                newDef.define(versionConfig, ConfigDef.Type.STRING, (Object)defaultVersion, versionValidator, ConfigDef.Importance.HIGH, "Version of the '" + alias + "' " + this.aliasKind.toLowerCase(Locale.ENGLISH) + ".", group, orderInGroup++, ConfigDef.Width.LONG, this.baseClass.getSimpleName() + " version for " + alias, Collections.emptyList(), this.versionRecommender(typeConfig));
                ConfigDef configDef = this.populateConfigDef(typeConfig, versionConfig, plugins);
                if (configDef == null) continue;
                newDef.embed(prefix, group, orderInGroup, configDef);
            }
        }

        protected void validateProps(String prefix) {
        }

        protected ConfigDef populateConfigDef(String typeConfig, String versionConfig, Plugins plugins) {
            ConfigDef configDef = this.initialConfigDef();
            try {
                this.configDefsForClass(typeConfig, versionConfig, plugins).forEach(entry -> configDef.define((ConfigDef.ConfigKey)entry.getValue()));
            }
            catch (ConfigException e) {
                if (this.requireFullConfig) {
                    throw e;
                }
                return null;
            }
            return configDef;
        }

        protected Stream<Map.Entry<String, ConfigDef.ConfigKey>> configDefsForClass(String typeConfig, String versionConfig, Plugins plugins) {
            if (this.props.get(typeConfig) == null) {
                throw new ConfigException(typeConfig, null, "Not a " + this.baseClass.getSimpleName());
            }
            return this.getConfigDefFromPlugin(typeConfig, this.props.get(typeConfig), this.props.get(versionConfig), plugins).configKeys().entrySet().stream();
        }

        protected ConfigDef initialConfigDef() {
            return new ConfigDef();
        }

        ConfigDef getConfigDefFromPlugin(String key, String pluginClass, String version, Plugins plugins) {
            Object plugin;
            VersionRange pluginVersion;
            VersionRange connectorVersionRange;
            String connectorClass = this.props.get(ConnectorConfig.CONNECTOR_CLASS_CONFIG);
            if (pluginClass == null || connectorClass == null) {
                return new ConfigDef();
            }
            try {
                connectorVersionRange = PluginUtils.connectorVersionRequirement(this.props.get(ConnectorConfig.CONNECTOR_VERSION));
            }
            catch (InvalidVersionSpecificationException e) {
                return new ConfigDef();
            }
            try {
                pluginVersion = PluginUtils.connectorVersionRequirement(version);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionedPluginLoadingException(e.getMessage());
            }
            Class cls = (Class)ConfigDef.parseType((String)key, (Object)this.props.get(key), (ConfigDef.Type)ConfigDef.Type.CLASS);
            Utils.ensureConcreteSubclass(this.baseClass, (Class)cls);
            try {
                plugin = plugins.newPlugin(pluginClass, pluginVersion, plugins.connectorLoader(connectorClass, connectorVersionRange));
            }
            catch (VersionedPluginLoadingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigException(key, (Object)pluginClass, "Error getting config definition from " + this.baseClass.getSimpleName() + ": " + e.getMessage());
            }
            ConfigDef configDef = this.config(plugin);
            if (null == configDef) {
                throw new ConnectException(String.format("%s.config() must return a ConfigDef that is not null.", plugin.getClass().getName()));
            }
            return configDef;
        }

        protected abstract ConfigDef config(T var1);

        protected abstract Set<PluginDesc<T>> plugins();

        protected abstract ConfigDef.Recommender versionRecommender(String var1);

        final class ClassRecommender
        implements ConfigDef.Recommender {
            ClassRecommender() {
            }

            public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
                ArrayList result = new ArrayList();
                for (PluginDesc plugin : EnrichablePlugin.this.plugins()) {
                    result.add(plugin.pluginClass());
                }
                return Collections.unmodifiableList(result);
            }

            public boolean visible(String name, Map<String, Object> parsedConfig) {
                return true;
            }
        }
    }
}

