/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;

public class ShareGroupConfig {
    public static final String SHARE_GROUP_ENABLE_CONFIG = "group.share.enable";
    public static final boolean SHARE_GROUP_ENABLE_DEFAULT = false;
    public static final String SHARE_GROUP_ENABLE_DOC = "Enable share groups on the broker.";
    public static final String SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS_CONFIG = "group.share.partition.max.record.locks";
    public static final int SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS_DEFAULT = 2000;
    public static final String SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS_DOC = "Share-group record lock limit per share-partition.";
    public static final String SHARE_GROUP_DELIVERY_COUNT_LIMIT_CONFIG = "group.share.delivery.count.limit";
    public static final int SHARE_GROUP_DELIVERY_COUNT_LIMIT_DEFAULT = 5;
    public static final String SHARE_GROUP_DELIVERY_COUNT_LIMIT_DOC = "The maximum number of delivery attempts for a record delivered to a share group.";
    public static final String SHARE_GROUP_RECORD_LOCK_DURATION_MS_CONFIG = "group.share.record.lock.duration.ms";
    public static final int SHARE_GROUP_RECORD_LOCK_DURATION_MS_DEFAULT = 30000;
    public static final String SHARE_GROUP_RECORD_LOCK_DURATION_MS_DOC = "The record acquisition lock duration in milliseconds for share groups.";
    public static final String SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_CONFIG = "group.share.min.record.lock.duration.ms";
    public static final int SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_DEFAULT = 15000;
    public static final String SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_DOC = "The record acquisition lock minimum duration in milliseconds for share groups.";
    public static final String SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_CONFIG = "group.share.max.record.lock.duration.ms";
    public static final int SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_DEFAULT = 60000;
    public static final String SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_DOC = "The record acquisition lock maximum duration in milliseconds for share groups.";
    public static final String SHARE_FETCH_PURGATORY_PURGE_INTERVAL_REQUESTS_CONFIG = "share.fetch.purgatory.purge.interval.requests";
    public static final int SHARE_FETCH_PURGATORY_PURGE_INTERVAL_REQUESTS_DEFAULT = 1000;
    public static final String SHARE_FETCH_PURGATORY_PURGE_INTERVAL_REQUESTS_DOC = "The purge interval (in number of requests) of the share fetch request purgatory";
    public static final String SHARE_GROUP_MAX_SHARE_SESSIONS_CONFIG = "group.share.max.share.sessions";
    public static final int SHARE_GROUP_MAX_SHARE_SESSIONS_DEFAULT = 2000;
    public static final String SHARE_GROUP_MAX_SHARE_SESSIONS_DOC = "The maximum number of share sessions per broker.";
    public static final String SHARE_GROUP_PERSISTER_CLASS_NAME_CONFIG = "group.share.persister.class.name";
    public static final String SHARE_GROUP_PERSISTER_CLASS_NAME_DEFAULT = "org.apache.kafka.server.share.persister.DefaultStatePersister";
    public static final String SHARE_GROUP_PERSISTER_CLASS_NAME_DOC = "The fully qualified name of a class which implements the <code>org.apache.kafka.server.share.Persister</code> interface.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().defineInternal("group.share.enable", ConfigDef.Type.BOOLEAN, (Object)false, null, ConfigDef.Importance.MEDIUM, "Enable share groups on the broker.").define("group.share.delivery.count.limit", ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.between((Number)2, (Number)10), ConfigDef.Importance.MEDIUM, "The maximum number of delivery attempts for a record delivered to a share group.").define("group.share.record.lock.duration.ms", ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.between((Number)1000, (Number)3600000), ConfigDef.Importance.MEDIUM, "The record acquisition lock duration in milliseconds for share groups.").define("group.share.min.record.lock.duration.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.between((Number)1000, (Number)30000), ConfigDef.Importance.MEDIUM, "The record acquisition lock minimum duration in milliseconds for share groups.").define("group.share.max.record.lock.duration.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.between((Number)30000, (Number)3600000), ConfigDef.Importance.MEDIUM, "The record acquisition lock maximum duration in milliseconds for share groups.").define("group.share.partition.max.record.locks", ConfigDef.Type.INT, (Object)2000, (ConfigDef.Validator)ConfigDef.Range.between((Number)100, (Number)10000), ConfigDef.Importance.MEDIUM, "Share-group record lock limit per share-partition.").define("share.fetch.purgatory.purge.interval.requests", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, "The purge interval (in number of requests) of the share fetch request purgatory").define("group.share.max.share.sessions", ConfigDef.Type.INT, (Object)2000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of share sessions per broker.").defineInternal("group.share.persister.class.name", ConfigDef.Type.STRING, (Object)"org.apache.kafka.server.share.persister.DefaultStatePersister", null, ConfigDef.Importance.MEDIUM, "The fully qualified name of a class which implements the <code>org.apache.kafka.server.share.Persister</code> interface.");
    private final boolean isShareGroupEnabled;
    private final int shareGroupPartitionMaxRecordLocks;
    private final int shareGroupDeliveryCountLimit;
    private final int shareGroupRecordLockDurationMs;
    private final int shareGroupMaxRecordLockDurationMs;
    private final int shareGroupMinRecordLockDurationMs;
    private final int shareFetchPurgatoryPurgeIntervalRequests;
    private final int shareGroupMaxShareSessions;
    private final String shareGroupPersisterClassName;
    private final AbstractConfig config;

    public ShareGroupConfig(AbstractConfig config) {
        this.config = config;
        this.isShareGroupEnabled = config.getBoolean(SHARE_GROUP_ENABLE_CONFIG);
        this.shareGroupPartitionMaxRecordLocks = config.getInt(SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS_CONFIG);
        this.shareGroupDeliveryCountLimit = config.getInt(SHARE_GROUP_DELIVERY_COUNT_LIMIT_CONFIG);
        this.shareGroupRecordLockDurationMs = config.getInt(SHARE_GROUP_RECORD_LOCK_DURATION_MS_CONFIG);
        this.shareGroupMaxRecordLockDurationMs = config.getInt(SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_CONFIG);
        this.shareGroupMinRecordLockDurationMs = config.getInt(SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_CONFIG);
        this.shareFetchPurgatoryPurgeIntervalRequests = config.getInt(SHARE_FETCH_PURGATORY_PURGE_INTERVAL_REQUESTS_CONFIG);
        this.shareGroupMaxShareSessions = config.getInt(SHARE_GROUP_MAX_SHARE_SESSIONS_CONFIG);
        this.shareGroupPersisterClassName = config.getString(SHARE_GROUP_PERSISTER_CLASS_NAME_CONFIG);
        this.validate();
    }

    public boolean isShareGroupEnabled() {
        return this.isShareGroupEnabled;
    }

    public int shareGroupPartitionMaxRecordLocks() {
        return this.shareGroupPartitionMaxRecordLocks;
    }

    public int shareGroupDeliveryCountLimit() {
        return this.shareGroupDeliveryCountLimit;
    }

    public int shareGroupRecordLockDurationMs() {
        return this.shareGroupRecordLockDurationMs;
    }

    public int shareGroupMaxRecordLockDurationMs() {
        return this.shareGroupMaxRecordLockDurationMs;
    }

    public int shareGroupMinRecordLockDurationMs() {
        return this.shareGroupMinRecordLockDurationMs;
    }

    public int shareFetchPurgatoryPurgeIntervalRequests() {
        return this.shareFetchPurgatoryPurgeIntervalRequests;
    }

    public int shareGroupMaxShareSessions() {
        return this.shareGroupMaxShareSessions;
    }

    public String shareGroupPersisterClassName() {
        return this.shareGroupPersisterClassName;
    }

    private void validate() {
        Utils.require((this.shareGroupRecordLockDurationMs >= this.shareGroupMinRecordLockDurationMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_RECORD_LOCK_DURATION_MS_CONFIG, SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_CONFIG));
        Utils.require((this.shareGroupMaxRecordLockDurationMs >= this.shareGroupRecordLockDurationMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_CONFIG, SHARE_GROUP_RECORD_LOCK_DURATION_MS_CONFIG));
        Utils.require((this.shareGroupMaxShareSessions >= this.config.getInt("group.share.max.size") ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_MAX_SHARE_SESSIONS_CONFIG, "group.share.max.size"));
    }

    public Map<String, Integer> extractShareGroupConfigMap(GroupCoordinatorConfig groupCoordinatorConfig) {
        return Map.of("share.session.timeout.ms", groupCoordinatorConfig.shareGroupSessionTimeoutMs(), "share.heartbeat.interval.ms", groupCoordinatorConfig.shareGroupHeartbeatIntervalMs(), "share.record.lock.duration.ms", this.shareGroupRecordLockDurationMs());
    }
}

