/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import java.net.InetAddress;
import jdk.jfr.events.SocketWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;
import jdk.jfr.internal.instrument.JITypeMapping;

@JIInstrumentationTarget(value="java.net.SocketOutputStream")
@JITypeMapping(from="jdk.jfr.internal.instrument.SocketOutputStreamInstrumentor$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl")
final class SocketOutputStreamInstrumentor {
    private AbstractPlainSocketImpl impl = null;

    private SocketOutputStreamInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    private void socketWrite(byte[] byArray, int n, int n2) throws IOException {
        SocketWriteEvent socketWriteEvent = SocketWriteEvent.EVENT.get();
        if (!socketWriteEvent.isEnabled()) {
            this.socketWrite(byArray, n, n2);
            return;
        }
        int n3 = 0;
        try {
            socketWriteEvent.begin();
            this.socketWrite(byArray, n, n2);
            n3 = n2;
        }
        catch (Throwable throwable) {
            socketWriteEvent.end();
            if (socketWriteEvent.shouldCommit()) {
                String string = this.impl.address.toString();
                int n4 = string.lastIndexOf(47);
                socketWriteEvent.host = string.substring(0, n4);
                socketWriteEvent.address = string.substring(n4 + 1);
                socketWriteEvent.port = this.impl.port;
                socketWriteEvent.bytesWritten = n3 < 0 ? 0L : (long)n3;
                socketWriteEvent.commit();
                socketWriteEvent.reset();
            }
            throw throwable;
        }
        socketWriteEvent.end();
        if (socketWriteEvent.shouldCommit()) {
            String string = this.impl.address.toString();
            int n5 = string.lastIndexOf(47);
            socketWriteEvent.host = string.substring(0, n5);
            socketWriteEvent.address = string.substring(n5 + 1);
            socketWriteEvent.port = this.impl.port;
            socketWriteEvent.bytesWritten = n3 < 0 ? 0L : (long)n3;
            socketWriteEvent.commit();
            socketWriteEvent.reset();
        }
    }

    void silenceFindBugsUnwrittenField(InetAddress inetAddress) {
        this.impl.address = inetAddress;
    }

    static class AbstractPlainSocketImpl {
        InetAddress address;
        int port;

        AbstractPlainSocketImpl() {
        }
    }
}

