/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.jfr.AnnotationElement;
import jdk.jfr.ContentType;
import jdk.jfr.internal.AnnotationConstruct;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class ValueDescriptor {
    private final AnnotationConstruct annotationConstruct;
    private final Type type;
    private final String name;
    private final boolean isArray;
    private final boolean constantPool;
    private final String javaFieldName;

    ValueDescriptor(Type type, String string, List<AnnotationElement> list, int n, boolean bl, String string2) {
        Objects.requireNonNull(list);
        if (n < 0) {
            throw new IllegalArgumentException("Dimension must be positive");
        }
        this.name = Objects.requireNonNull(string, "Name of value descriptor can't be null");
        this.type = Objects.requireNonNull(type);
        this.isArray = n > 0;
        this.constantPool = bl;
        this.annotationConstruct = new AnnotationConstruct(list);
        this.javaFieldName = string2;
    }

    public ValueDescriptor(Class<?> clazz, String string) {
        this(clazz, string, Collections.emptyList());
    }

    public ValueDescriptor(Class<?> clazz, String string, List<AnnotationElement> list) {
        this(clazz, string, new ArrayList<AnnotationElement>(list), false);
    }

    ValueDescriptor(Class<?> clazz, String string, List<AnnotationElement> list, boolean bl) {
        Objects.requireNonNull(list);
        Utils.checkRegisterPermission();
        if (!bl && clazz.isArray()) {
            throw new IllegalArgumentException("Array types are not allowed");
        }
        this.name = Objects.requireNonNull(string, "Name of value descriptor can't be null");
        this.type = Objects.requireNonNull(Utils.getValidType(Objects.requireNonNull(clazz), Objects.requireNonNull(string)));
        this.annotationConstruct = new AnnotationConstruct(list);
        this.javaFieldName = string;
        this.isArray = clazz.isArray();
        this.constantPool = clazz == Class.class || clazz == Thread.class;
    }

    public String getLabel() {
        return this.annotationConstruct.getLabel();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.annotationConstruct.getDescription();
    }

    public String getContentType() {
        for (AnnotationElement annotationElement : this.getAnnotationElements()) {
            for (AnnotationElement annotationElement2 : annotationElement.getAnnotationElements()) {
                if (!annotationElement2.getTypeName().equals(ContentType.class.getName())) continue;
                return annotationElement.getTypeName();
            }
        }
        return null;
    }

    public String getTypeName() {
        if (this.type.isSimpleType()) {
            return this.type.getFields().get(0).getTypeName();
        }
        return this.type.getName();
    }

    public long getTypeId() {
        return this.type.getId();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Objects.requireNonNull(clazz);
        return (A)((Annotation)this.annotationConstruct.getAnnotation(clazz));
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.annotationConstruct.getUnmodifiableAnnotationElements();
    }

    public List<ValueDescriptor> getFields() {
        if (this.type.isSimpleType()) {
            return Collections.emptyList();
        }
        return this.type.getFields();
    }

    Type getType() {
        return this.type;
    }

    void setAnnotations(List<AnnotationElement> list) {
        this.annotationConstruct.setAnnotationElements(list);
    }

    boolean isConstantPool() {
        return this.constantPool;
    }

    String getJavaFieldName() {
        return this.javaFieldName;
    }

    boolean isUnsigned() {
        return this.annotationConstruct.hasUnsigned();
    }
}

