/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter performs pixelwise voting among an arbitrary number of
input images, where each of them represents a segmentation of the same
scene (i.e., image).


Label voting is a simple method of classifier combination applied to image
segmentation. Typically, the accuracy of the combined segmentation
exceeds the accuracy of any of the input segmentations. Voting is
therefore commonly used as a way of boosting segmentation performance.

The use of label voting for combination of multiple segmentations is
described in

T. Rohlfing and C. R. Maurer, Jr., "Multi-classifier framework for
atlas-based image segmentation," Pattern Recognition Letters, 2005.

INPUTS
All input volumes to this filter must be segmentations of an image,
that is, they must have discrete pixel values where each value
represents a different segmented object.
 Input volumes must all contain the same size RequestedRegions. Not all input images must contain all possible labels, but all label
values must have the same meaning in all images.

OUTPUTS
The voting filter produces a single output volume. Each output pixel
contains the label that occurred most often among the labels assigned
to this pixel in all the input volumes, that is, the label that
received the maximum number of "votes" from the input pixels.. If
the maximum number of votes is not unique, i.e., if more than one
label have a maximum number of votes, an "undecided" label is
assigned to that output pixel.
 By default, the label used for undecided pixels is the maximum label
value used in the input images plus one. Since it is possible for an
image with 8 bit pixel values to use all 256 possible label values, it
is permissible to combine 8 bit (i.e., byte) images into a 16 bit
(i.e., short) output image.

PARAMETERS
The label used for "undecided" labels can be set using
SetLabelForUndecidedPixels. This functionality can be unset by calling
UnsetLabelForUndecidedPixels.

Torsten Rohlfing, SRI International, Neuroscience Program

See:
 itk::simple::LabelVoting for the procedural interface


C++ includes: sitkLabelVotingImageFilter.h
*/
public class LabelVotingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelVotingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelVotingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelVotingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelVotingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelVotingImageFilter::~LabelVotingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelVotingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelVotingImageFilter::LabelVotingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelVotingImageFilter() {
    this(SimpleITKJNI.new_LabelVotingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelVotingImageFilter::SetLabelForUndecidedPixels(uint64_t LabelForUndecidedPixels)

Set label value for undecided pixels.

*/
public  void setLabelForUndecidedPixels(java.math.BigInteger LabelForUndecidedPixels) {
    SimpleITKJNI.LabelVotingImageFilter_setLabelForUndecidedPixels(swigCPtr, this, LabelForUndecidedPixels);
  }

  /**
uint64_t itk::simple::LabelVotingImageFilter::GetLabelForUndecidedPixels() const

Get label value used for undecided pixels. After updating the filter,
this function returns the actual label value used for undecided pixels
in the current output. Note that this value is overwritten when
SetLabelForUndecidedPixels is called and the new value only becomes
effective upon the next filter update.

*/
public  java.math.BigInteger getLabelForUndecidedPixels() {
    return SimpleITKJNI.LabelVotingImageFilter_getLabelForUndecidedPixels(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelVotingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelVotingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelVotingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelVotingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LabelVotingImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(VectorOfImage images) {
    return new Image(SimpleITKJNI.LabelVotingImageFilter_execute__SWIG_0(swigCPtr, this, VectorOfImage.getCPtr(images), images), true);
  }

  /**
Image itk::simple::LabelVotingImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.LabelVotingImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::LabelVotingImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.LabelVotingImageFilter_execute__SWIG_2(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::LabelVotingImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.LabelVotingImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  /**
Image itk::simple::LabelVotingImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.LabelVotingImageFilter_execute__SWIG_4(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  /**
Image itk::simple::LabelVotingImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.LabelVotingImageFilter_execute__SWIG_5(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

}
