/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.math.BigInteger;
import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorUInt64
extends AbstractList<BigInteger>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorUInt64(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorUInt64 vectorUInt64) {
        return vectorUInt64 == null ? 0L : vectorUInt64.swigCPtr;
    }

    protected static long swigRelease(VectorUInt64 vectorUInt64) {
        long l = 0L;
        if (vectorUInt64 != null) {
            if (!vectorUInt64.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorUInt64.swigCPtr;
            vectorUInt64.swigCMemOwn = false;
            vectorUInt64.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorUInt64(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorUInt64(BigInteger[] bigIntegerArray) {
        this();
        this.doReserve(bigIntegerArray.length);
        for (BigInteger bigInteger : bigIntegerArray) {
            this.doAdd(bigInteger);
        }
    }

    public VectorUInt64(Iterable<BigInteger> iterable) {
        this();
        for (BigInteger bigInteger : iterable) {
            this.doAdd(bigInteger);
        }
    }

    @Override
    public BigInteger get(int n) {
        return this.doGet(n);
    }

    @Override
    public BigInteger set(int n, BigInteger bigInteger) {
        return this.doSet(n, bigInteger);
    }

    @Override
    public boolean add(BigInteger bigInteger) {
        ++this.modCount;
        this.doAdd(bigInteger);
        return true;
    }

    @Override
    public void add(int n, BigInteger bigInteger) {
        ++this.modCount;
        this.doAdd(n, bigInteger);
    }

    @Override
    public BigInteger remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorUInt64() {
        this(SimpleITKJNI.new_VectorUInt64__SWIG_0(), true);
    }

    public VectorUInt64(VectorUInt64 vectorUInt64) {
        this(SimpleITKJNI.new_VectorUInt64__SWIG_1(VectorUInt64.getCPtr(vectorUInt64), vectorUInt64), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorUInt64_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorUInt64_clear(this.swigCPtr, this);
    }

    public VectorUInt64(int n, BigInteger bigInteger) {
        this(SimpleITKJNI.new_VectorUInt64__SWIG_2(n, bigInteger), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorUInt64_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorUInt64_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorUInt64_doSize(this.swigCPtr, this);
    }

    private void doAdd(BigInteger bigInteger) {
        SimpleITKJNI.VectorUInt64_doAdd__SWIG_0(this.swigCPtr, this, bigInteger);
    }

    private void doAdd(int n, BigInteger bigInteger) {
        SimpleITKJNI.VectorUInt64_doAdd__SWIG_1(this.swigCPtr, this, n, bigInteger);
    }

    private BigInteger doRemove(int n) {
        return SimpleITKJNI.VectorUInt64_doRemove(this.swigCPtr, this, n);
    }

    private BigInteger doGet(int n) {
        return SimpleITKJNI.VectorUInt64_doGet(this.swigCPtr, this, n);
    }

    private BigInteger doSet(int n, BigInteger bigInteger) {
        return SimpleITKJNI.VectorUInt64_doSet(this.swigCPtr, this, n, bigInteger);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorUInt64_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

