/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasReturnType;
import com.tngtech.archunit.core.domain.properties.HasThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public abstract class AccessTarget
implements HasName.AndFullName,
CanBeAnnotated,
HasOwner<JavaClass>,
HasDescription {
    private final String name;
    private final JavaClass owner;
    private final String fullName;
    private final Supplier<? extends Optional<? extends JavaMember>> member;

    AccessTarget(DomainBuilders.AccessTargetBuilder<?, ?, ?> builder) {
        this.name = Preconditions.checkNotNull(builder.getName());
        this.owner = Preconditions.checkNotNull(builder.getOwner());
        this.fullName = Preconditions.checkNotNull(builder.getFullName());
        this.member = Suppliers.memoize(builder.getMember());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return this.name;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getOwner() {
        return this.owner;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFullName() {
        return this.fullName;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<? extends JavaMember> resolveMember() {
        return this.member.get();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.isAnnotatedWith(annotationType.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(String annotationTypeName) {
        return this.resolveMember().isPresent() && this.resolveMember().get().isAnnotatedWith(annotationTypeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.resolveMember().isPresent() && this.resolveMember().get().isAnnotatedWith(predicate);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.isMetaAnnotatedWith(annotationType.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(String annotationTypeName) {
        return this.resolveMember().isPresent() && this.resolveMember().get().isMetaAnnotatedWith(annotationTypeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.resolveMember().isPresent() && this.resolveMember().get().isMetaAnnotatedWith(predicate);
    }

    public int hashCode() {
        return Objects.hash(this.fullName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessTarget other = (AccessTarget)obj;
        return Objects.equals(this.fullName, other.fullName);
    }

    public String toString() {
        return "target{" + this.fullName + '}';
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<AccessTarget> declaredIn(Class<?> clazz) {
            return Predicates.declaredIn(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<AccessTarget> declaredIn(String className) {
            return Predicates.declaredIn(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(className)).as(className, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<AccessTarget> declaredIn(DescribedPredicate<? super JavaClass> predicate) {
            return HasOwner.Functions.Get.owner().is(predicate).as("declared in %s", predicate.getDescription()).forSubtype();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<AccessTarget> constructor() {
            return new DescribedPredicate<AccessTarget>("constructor", new Object[0]){

                @Override
                public boolean test(AccessTarget input) {
                    return "<init>".equals(input.getName());
                }
            };
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class MethodReferenceTarget
    extends CodeUnitReferenceTarget {
        MethodReferenceTarget(DomainBuilders.CodeUnitAccessTargetBuilder<JavaMethod, MethodReferenceTarget> builder) {
            super(builder);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ThrowsClause<MethodReferenceTarget> getThrowsClause() {
            return super.getThrowsClause();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<JavaMethod> resolveMember() {
            return super.resolveMember();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            return "method <" + this.getFullName() + ">";
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<MethodReferenceTarget, Optional<JavaMethod>> RESOLVE_MEMBER = new ChainableFunction<MethodReferenceTarget, Optional<JavaMethod>>(){

                @Override
                public Optional<JavaMethod> apply(MethodReferenceTarget input) {
                    return input.resolveMember();
                }
            };

            private Functions() {
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class MethodCallTarget
    extends CodeUnitCallTarget {
        MethodCallTarget(DomainBuilders.CodeUnitAccessTargetBuilder<JavaMethod, MethodCallTarget> builder) {
            super(builder);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ThrowsClause<MethodCallTarget> getThrowsClause() {
            return super.getThrowsClause();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<JavaMethod> resolveMember() {
            return super.resolveMember();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            return "method <" + this.getFullName() + ">";
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<MethodCallTarget, Optional<JavaMethod>> RESOLVE_MEMBER = new ChainableFunction<MethodCallTarget, Optional<JavaMethod>>(){

                @Override
                public Optional<JavaMethod> apply(MethodCallTarget input) {
                    return input.resolveMember();
                }
            };

            private Functions() {
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class ConstructorReferenceTarget
    extends CodeUnitReferenceTarget {
        ConstructorReferenceTarget(DomainBuilders.CodeUnitAccessTargetBuilder<JavaConstructor, ConstructorReferenceTarget> builder) {
            super(builder);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ThrowsClause<ConstructorReferenceTarget> getThrowsClause() {
            return super.getThrowsClause();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<JavaConstructor> resolveMember() {
            return super.resolveMember();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            return "constructor <" + this.getFullName() + ">";
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<ConstructorReferenceTarget, Optional<JavaConstructor>> RESOLVE_MEMBER = new ChainableFunction<ConstructorReferenceTarget, Optional<JavaConstructor>>(){

                @Override
                public Optional<JavaConstructor> apply(ConstructorReferenceTarget input) {
                    return input.resolveMember();
                }
            };

            private Functions() {
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class ConstructorCallTarget
    extends CodeUnitCallTarget {
        ConstructorCallTarget(DomainBuilders.CodeUnitAccessTargetBuilder<JavaConstructor, ConstructorCallTarget> builder) {
            super(builder);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ThrowsClause<ConstructorCallTarget> getThrowsClause() {
            return super.getThrowsClause();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<JavaConstructor> resolveMember() {
            return super.resolveMember();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            return "constructor <" + this.getFullName() + ">";
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<ConstructorCallTarget, Optional<JavaConstructor>> RESOLVE_MEMBER = new ChainableFunction<ConstructorCallTarget, Optional<JavaConstructor>>(){

                @Override
                public Optional<JavaConstructor> apply(ConstructorCallTarget input) {
                    return input.resolveMember();
                }
            };

            private Functions() {
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static abstract class CodeUnitReferenceTarget
    extends CodeUnitAccessTarget {
        CodeUnitReferenceTarget(DomainBuilders.CodeUnitAccessTargetBuilder<?, ?> builder) {
            super(builder);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ThrowsClause<? extends CodeUnitReferenceTarget> getThrowsClause() {
            return super.getThrowsClause();
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static abstract class CodeUnitCallTarget
    extends CodeUnitAccessTarget {
        CodeUnitCallTarget(DomainBuilders.CodeUnitAccessTargetBuilder<?, ?> builder) {
            super(builder);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ThrowsClause<? extends CodeUnitCallTarget> getThrowsClause() {
            return super.getThrowsClause();
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static abstract class CodeUnitAccessTarget
    extends AccessTarget
    implements HasParameterTypes,
    HasReturnType,
    HasThrowsClause<CodeUnitAccessTarget> {
        private final ImmutableList<JavaClass> parameters;
        private final JavaClass returnType;

        CodeUnitAccessTarget(DomainBuilders.CodeUnitAccessTargetBuilder<?, ?> builder) {
            super(builder);
            this.parameters = ImmutableList.copyOf(builder.getParameters());
            this.returnType = Preconditions.checkNotNull(builder.getReturnType());
        }

        @Override
        public List<JavaType> getParameterTypes() {
            return this.parameters;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public List<JavaClass> getRawParameterTypes() {
            return this.parameters;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public JavaType getReturnType() {
            return this.returnType;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public JavaClass getRawReturnType() {
            return this.returnType;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ThrowsClause<? extends CodeUnitAccessTarget> getThrowsClause() {
            Optional resolvedThrowsClauses = this.resolveMember().map(JavaCodeUnit.Functions.Get.throwsClause());
            if (resolvedThrowsClauses.isPresent()) {
                return ThrowsClause.from(this, resolvedThrowsClauses.get().getTypes());
            }
            return ThrowsClause.empty(this);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<? extends JavaCodeUnit> resolveMember() {
            return super.resolveMember();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<CodeUnitAccessTarget, Optional<JavaCodeUnit>> RESOLVE_MEMBER = new ChainableFunction<CodeUnitAccessTarget, Optional<JavaCodeUnit>>(){

                @Override
                public Optional<JavaCodeUnit> apply(CodeUnitAccessTarget input) {
                    return input.resolveMember();
                }
            };

            private Functions() {
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class FieldAccessTarget
    extends AccessTarget
    implements HasType {
        private final JavaClass type;

        FieldAccessTarget(DomainBuilders.FieldAccessTargetBuilder builder) {
            super(builder);
            this.type = Preconditions.checkNotNull(builder.getType());
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public JavaType getType() {
            return this.type;
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public JavaClass getRawType() {
            return this.type;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public Optional<JavaField> resolveMember() {
            return super.resolveMember();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            return "field <" + this.getFullName() + ">";
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<FieldAccessTarget, Optional<JavaField>> RESOLVE_MEMBER = new ChainableFunction<FieldAccessTarget, Optional<JavaField>>(){

                @Override
                public Optional<JavaField> apply(FieldAccessTarget input) {
                    return input.resolveMember();
                }
            };

            private Functions() {
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<AccessTarget, Optional<JavaMember>> RESOLVE_MEMBER = new ChainableFunction<AccessTarget, Optional<JavaMember>>(){

            @Override
            public Optional<JavaMember> apply(AccessTarget input) {
                return input.resolveMember();
            }
        };

        private Functions() {
        }
    }
}

