/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.graph.GraphNodeSort;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.DeletedContentNode;
import org.freeplane.plugin.codeexplorer.map.DistinctTargetDependencyFilter;
import org.freeplane.plugin.codeexplorer.map.GroupFinder;
import org.freeplane.plugin.codeexplorer.map.PackageNode;
import org.freeplane.plugin.codeexplorer.map.SubgroupComparator;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;
import org.freeplane.plugin.codeexplorer.task.UserDefinedCodeExplorerConfiguration;

class ProjectNode
extends CodeNode
implements GroupFinder {
    private static final int ROOT_INDEX = -1;
    static final String UI_ROOT_ICON_NAME = "code_project";
    private static final Map.Entry<Integer, String> UNKNOWN;
    private final JavaPackage rootPackage;
    private final Map<String, Map.Entry<Integer, String>> projectIdsByLocation;
    private final String[] idBySubrojectIndex;
    private final Set<String> badLocations;
    private final JavaClasses classes;
    private final long classCount;
    private final GroupMatcher groupMatcher;

    static ProjectNode asMapRoot(String projectName, CodeMap map, JavaClasses classes, GroupMatcher groupMatcher) {
        ProjectNode projectNode = new ProjectNode(projectName, map, classes, groupMatcher);
        map.setRoot(projectNode);
        if (projectNode.getChildCount() > 20) {
            projectNode.getChildren().forEach(node -> ((CodeNode)((Object)node)).memoizeCodeDependencies());
        }
        return projectNode;
    }

    private ProjectNode(String projectName, CodeMap map, JavaClasses classes, GroupMatcher groupMatcher) {
        this(projectName, ":projectRoot:", map, -1, classes, groupMatcher, new ConcurrentHashMap<String, Map.Entry<Integer, String>>());
    }

    @Override
    String idWithOwnGroupIndex(String idWithoutIndex) {
        return this.groupIndex >= 0 ? super.idWithOwnGroupIndex(idWithoutIndex) : idWithoutIndex;
    }

    private ProjectNode(String projectName, String idWithoutIndex, CodeMap map, int groupIndex, JavaClasses classes, GroupMatcher groupMatcher, Map<String, Map.Entry<Integer, String>> projectIdsByLocation) {
        super(map, groupIndex);
        this.classes = classes;
        this.groupMatcher = groupMatcher;
        this.rootPackage = classes.getDefaultPackage();
        this.projectIdsByLocation = projectIdsByLocation;
        this.setID(this.idWithOwnGroupIndex(idWithoutIndex));
        if (this.isRoot()) {
            classes.stream().map(groupMatcher::projectIdentifier).filter(Optional::isPresent).map(Optional::get).forEach(this::addLocation);
            map.setGroupFinder(this);
        }
        this.badLocations = new HashSet<String>();
        this.initializeChildNodes(map);
        this.classCount = super.getChildrenInternal().stream().map(CodeNode.class::cast).mapToLong(CodeNode::getClassCount).sum();
        this.setText(projectName + ProjectNode.formatClassCount(this.classCount));
        if (this.isRoot()) {
            this.addDeletedLocations(map);
        }
        this.idBySubrojectIndex = new String[projectIdsByLocation.size()];
        projectIdsByLocation.entrySet().forEach(e -> {
            this.idBySubrojectIndex[((Integer)((Map.Entry)e.getValue()).getKey()).intValue()] = (String)e.getKey();
        });
    }

    private void addDeletedLocation(String location) {
        Map.Entry<Integer, String> locationEntry = this.addLocation(new GroupIdentifier(location, location));
        int childIndex = locationEntry.getKey();
        if (childIndex == this.getChildCount()) {
            this.insert(new DeletedContentNode(this.getMap(), "", childIndex, locationEntry.getValue()));
        }
    }

    private Map.Entry<Integer, String> addLocation(GroupIdentifier identifier) {
        return this.projectIdsByLocation.computeIfAbsent(identifier.getId(), key -> new AbstractMap.SimpleEntry<Integer, String>(this.projectIdsByLocation.size(), identifier.getName()));
    }

    private void initializeChildNodes(CodeMap map) {
        Set groups = this.classes.stream().map(this.groupMatcher::groupIdentifier).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        List children = super.getChildrenInternal();
        Map<Integer, CodeNode> nodes = ((Stream)groups.stream().parallel()).map(gi -> this.groupMatcher.subgroupMatcher(gi.getId()).map(subgroupMatcher -> new ProjectNode(gi.getName(), this.getID(), map, this.addLocation((GroupIdentifier)gi).getKey(), this.classes, (GroupMatcher)subgroupMatcher, this.projectIdsByLocation)).orElseGet(() -> new PackageNode(this.rootPackage, this.getMap(), gi.getName(), this.projectIdsByLocation.get(gi.getId()).getKey(), true))).collect(Collectors.toMap(x -> x.groupIndex, x -> x));
        GraphNodeSort<Integer> childNodes = new GraphNodeSort<Integer>();
        Integer[] subrojectIndices = (Integer[])IntStream.range(0, this.projectIdsByLocation.size()).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        nodes.values().stream().filter(node -> node.getClassCount() > 0L).forEach(node -> {
            childNodes.addNode(node.groupIndex);
            DistinctTargetDependencyFilter filter = new DistinctTargetDependencyFilter();
            Map<Integer, Long> referencedGroups = node.getOutgoingDependenciesWithKnownTargets().map(filter::knownDependency).map(Dependency::getTargetClass).mapToInt(t -> this.groupIndexOf((JavaClass)t)).filter(i -> i >= 0).mapToObj(i -> subrojectIndices[i]).collect(Collectors.groupingBy(i -> i, Collectors.counting()));
            referencedGroups.entrySet().forEach(e -> childNodes.addEdge(subrojectIndices[node.groupIndex], (Integer)e.getKey(), ((Long)e.getValue()).longValue()));
        });
        Comparator<Set> comparingByReversedClassCount = Comparator.comparing(indices -> -indices.stream().map(nodes::get).mapToLong(CodeNode::getClassCount).sum());
        List<List<Integer>> orderedPackages = childNodes.sortNodes(Comparator.comparing(i -> ((CodeNode)((Object)((Object)nodes.get(i)))).getText()), comparingByReversedClassCount.thenComparing(SubgroupComparator.comparingByName(i -> ((CodeNode)((Object)((Object)nodes.get(i)))).getText())));
        for (int subgroupIndex = 0; subgroupIndex < orderedPackages.size(); ++subgroupIndex) {
            for (Integer groupIndex : orderedPackages.get(subgroupIndex)) {
                CodeNode node2 = nodes.get(groupIndex);
                children.add(node2);
                node2.setParent(this);
            }
        }
        for (NodeModel child : children) {
            ((CodeNode)child).setInitialFoldingState();
        }
    }

    private void addDeletedLocations(CodeMap map) {
        CodeExplorerConfiguration configuration = map.getConfiguration();
        if (configuration instanceof UserDefinedCodeExplorerConfiguration) {
            ((UserDefinedCodeExplorerConfiguration)configuration).getUserContent().keySet().forEach(this::addDeletedLocation);
        }
    }

    public boolean isRoot() {
        return this.groupIndex == -1;
    }

    @Override
    HasName getCodeElement() {
        return this.isRoot() ? () -> "root" : () -> "subproject";
    }

    @Override
    Stream<Dependency> getOutgoingDependencies() {
        if (this.isRoot()) {
            return Stream.empty();
        }
        return this.getChildren().stream().map(CodeNode.class::cast).flatMap(CodeNode::getOutgoingDependencies).filter(d -> !this.groupMatcher.belongsToGroup(d.getTargetClass()));
    }

    @Override
    Stream<Dependency> getIncomingDependencies() {
        if (this.isRoot()) {
            return Stream.empty();
        }
        return this.getChildren().stream().map(CodeNode.class::cast).flatMap(CodeNode::getIncomingDependencies).filter(d -> !this.groupMatcher.belongsToGroup(d.getOriginClass()));
    }

    @Override
    String getUIIconName() {
        return this.isRoot() ? UI_ROOT_ICON_NAME : "code_root_package";
    }

    @Override
    public boolean isKnown(JavaClass javaClass) {
        return this.groupMatcher.belongsToGroup(javaClass);
    }

    @Override
    public int projectIndexOf(JavaClass javaClass) {
        return this.indexOf(javaClass, this.groupMatcher.projectIdentifier(javaClass));
    }

    private int groupIndexOf(JavaClass javaClass) {
        return this.indexOf(javaClass, this.groupMatcher.groupIdentifier(javaClass));
    }

    private int indexOf(JavaClass javaClass, Optional<GroupIdentifier> identifier) {
        Optional<String> classSourceLocation = identifier.map(GroupIdentifier::getId);
        Optional<Map.Entry> groupEntry = classSourceLocation.map(s -> this.projectIdsByLocation.getOrDefault(s, UNKNOWN));
        if (groupEntry.filter(UNKNOWN::equals).isPresent() && this.badLocations.add(classSourceLocation.get())) {
            LogUtils.info((String)("Unknown class source location " + ((Source)javaClass.getSource().get()).getUri()));
        }
        return groupEntry.orElse(UNKNOWN).getKey();
    }

    @Override
    public int groupIndexOf(String location) {
        return this.projectIdsByLocation.getOrDefault(location, UNKNOWN).getKey();
    }

    @Override
    public Stream<JavaClass> allClasses() {
        return this.getClasses();
    }

    @Override
    public Stream<JavaClass> getClasses() {
        Stream<JavaClass> allClasses = this.classes.stream();
        return this.isRoot() ? allClasses : allClasses.filter(this::belongsToSameGroup);
    }

    @Override
    long getClassCount() {
        return this.classCount;
    }

    JavaClasses getImportedClasses() {
        return this.classes;
    }

    @Override
    public String getIdByIndex(int index) {
        if (index >= 0 && index < this.idBySubrojectIndex.length) {
            return this.idBySubrojectIndex[index];
        }
        throw new IllegalArgumentException("Bad index " + index);
    }

    @Override
    public Optional<GroupMatcher.MatchingCriteria> matchingCriteria(JavaClass javaClass) {
        return this.groupMatcher.matchingCriteria(javaClass);
    }

    @Override
    public Optional<GroupMatcher.MatchingCriteria> matchingCriteria(JavaClass originClass, JavaClass targetClass) {
        return this.groupMatcher.matchingCriteria(originClass, targetClass);
    }

    static {
        IconStoreFactory.INSTANCE.createStateIcon(UI_ROOT_ICON_NAME, "code/homeFolder.svg");
        UNKNOWN = new AbstractMap.SimpleEntry<Integer, String>(-1, ":unknown:");
    }
}

