/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.cloud;

import java.awt.Graphics2D;
import java.awt.Polygon;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.cloud.CloudView;

public class StarCloudView
extends CloudView {
    StarCloudView(CloudModel cloudModel, NodeView source) {
        super(cloudModel, source);
    }

    @Override
    protected void paintDecoration(Graphics2D g, Graphics2D gstroke, double x0, double y0, double x1, double y1, double dx, double dy, double dxn, double dyn) {
        double middleDistanceToConvexHull = this.getDistanceToConvexHull();
        double distanceToConvexHull = middleDistanceToConvexHull * this.random(0.5);
        double k = this.random(0.3);
        double xctrl = x0 + 0.5 * dx * k - distanceToConvexHull * dyn;
        double yctrl = y0 + 0.5 * dy * k + distanceToConvexHull * dxn;
        Polygon shape = new Polygon();
        shape.addPoint((int)x0, (int)y0);
        shape.addPoint((int)xctrl, (int)yctrl);
        shape.addPoint((int)x1, (int)y1);
        g.fill(shape);
        gstroke.drawLine((int)x0, (int)y0, (int)xctrl, (int)yctrl);
        gstroke.drawLine((int)xctrl, (int)yctrl, (int)x1, (int)y1);
    }

    @Override
    protected double getDistanceToConvexHull() {
        return 3.0 * super.getDistanceToConvexHull();
    }
}

