/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.hover;

import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class TitledTabTabbedPanelHoverAction
implements HoverListener {
    private TabbedPanelProperties tabbedPanelProperties;
    private TitledTabProperties titledTabProperties;
    private boolean applied = false;
    private boolean onlyHighlighted;
    private TabAdapter tabListener = new TabAdapter(){

        @Override
        public void tabHighlighted(TabStateChangedEvent event) {
            if (event.getCurrentTab() != null && TitledTabTabbedPanelHoverAction.this.onlyHighlighted) {
                TitledTabTabbedPanelHoverAction.this.applyTabbedPanel(event.getCurrentTab().getTabbedPanel());
            }
        }

        @Override
        public void tabDehighlighted(TabStateChangedEvent event) {
            if (event.getPreviousTab() != null && TitledTabTabbedPanelHoverAction.this.onlyHighlighted) {
                TitledTabTabbedPanelHoverAction.this.removeTabbedPanel(event.getPreviousTab().getTabbedPanel());
            }
        }
    };

    public TitledTabTabbedPanelHoverAction() {
        this(new TitledTabProperties(), new TabbedPanelProperties());
    }

    public TitledTabTabbedPanelHoverAction(boolean allTabs) {
        this(new TitledTabProperties(), new TabbedPanelProperties(), allTabs);
    }

    public TitledTabTabbedPanelHoverAction(TitledTabProperties titledTabProperties, TabbedPanelProperties tabbedPanelProperties) {
        this(titledTabProperties, tabbedPanelProperties, false);
    }

    public TitledTabTabbedPanelHoverAction(TitledTabProperties titledTabProperties, TabbedPanelProperties tabbedPanelProperties, boolean allTabs) {
        this.titledTabProperties = titledTabProperties;
        this.tabbedPanelProperties = tabbedPanelProperties;
        this.onlyHighlighted = !allTabs;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    @Override
    public void mouseEntered(HoverEvent event) {
        TitledTab tab = (TitledTab)event.getSource();
        if (this.onlyHighlighted) {
            tab.addTabListener(this.tabListener);
            if (tab.isHighlighted()) {
                this.applyTabbedPanel(tab.getTabbedPanel());
            }
        } else {
            this.applyTabbedPanel(tab.getTabbedPanel());
        }
        tab.getProperties().addSuperObject(this.titledTabProperties);
    }

    @Override
    public void mouseExited(HoverEvent event) {
        TitledTab tab = (TitledTab)event.getSource();
        this.removeTabbedPanel(tab.getTabbedPanel());
        if (this.onlyHighlighted) {
            tab.removeTabListener(this.tabListener);
        }
        tab.getProperties().removeSuperObject(this.titledTabProperties);
    }

    private void applyTabbedPanel(TabbedPanel tabbedPanel) {
        if (!this.applied) {
            tabbedPanel.getProperties().addSuperObject(this.tabbedPanelProperties);
            this.applied = true;
        }
    }

    private void removeTabbedPanel(TabbedPanel tabbedPanel) {
        if (this.applied) {
            tabbedPanel.getProperties().removeSuperObject(this.tabbedPanelProperties);
            this.applied = false;
        }
    }
}

