/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class MaxNodeWidthControlGroup
implements ControlGroup {
    private static final String MAX_NODE_WIDTH = "max_node_width";
    private static final String REVERT = "revert-max_node_width";
    private RevertingProperty mSetMaxNodeWidth;
    private QuantityProperty<LengthUnit> mMaxNodeWidth;
    private MaxNodeWidthChangeListener propertyChangeListener;

    MaxNodeWidthControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetMaxNodeWidth = new RevertingProperty(REVERT);
        this.mMaxNodeWidth = new QuantityProperty(MAX_NODE_WIDTH, 0.0, 100000.0, 0.1, (Enum)LengthUnit.px);
        this.propertyChangeListener = new MaxNodeWidthChangeListener(this.mSetMaxNodeWidth, new IPropertyControl[]{this.mMaxNodeWidth});
        this.mSetMaxNodeWidth.addPropertyChangeListener(this.propertyChangeListener);
        this.mMaxNodeWidth.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mMaxNodeWidth.appendToForm(formBuilder);
        this.mSetMaxNodeWidth.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class MaxNodeWidthChangeListener
    extends ControlGroupChangeListener {
        public MaxNodeWidthChangeListener(RevertingProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setMaxNodeWidth(node, enabled ? MaxNodeWidthControlGroup.this.mMaxNodeWidth.getQuantifiedValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeSizeModel nodeSizeModel = NodeSizeModel.getModel((NodeModel)node);
            NodeStyleController styleController = NodeStyleController.getController();
            Quantity width = nodeSizeModel != null ? nodeSizeModel.getMaxNodeWidth() : null;
            Quantity viewWidth = styleController.getMaxWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            MaxNodeWidthControlGroup.this.mSetMaxNodeWidth.setValue(width != null);
            MaxNodeWidthControlGroup.this.mMaxNodeWidth.setQuantifiedValue(viewWidth);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, MaxNodeWidthControlGroup.this.mSetMaxNodeWidth);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)MaxNodeWidthControlGroup.this.mMaxNodeWidth);
        }
    }
}

