/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode;

import java.util.List;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.bookmarks.mindmapmode.BookmarkEditor;
import org.freeplane.features.bookmarks.mindmapmode.BookmarkNodeAction;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksBuilder;
import org.freeplane.features.bookmarks.mindmapmode.FocusBookmarkToolbarAction;
import org.freeplane.features.bookmarks.mindmapmode.MapBookmarks;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmarkDescriptor;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarksToolbarBuilder;
import org.freeplane.features.filter.condition.CJKNormalizer;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.TextController;

public class BookmarksController
implements IExtension {
    public static final String SHOW_BOOKMARK_ICONS = "show_bookmark_icons";
    private static final UIIcon bookmarkIcon = IconStoreFactory.ICON_STORE.getUIIcon("node-bookmark.svg");
    private static final UIIcon bookmarkAsRootIcon = IconStoreFactory.ICON_STORE.getUIIcon("node-bookmark-root.svg");
    private final ModeController modeController;
    private final BookmarksToolbarBuilder toolbarBuilder;
    private final BookmarkEditor bookmarkEditor;

    public BookmarksController(ModeController modeController) {
        this.modeController = modeController;
        this.toolbarBuilder = new BookmarksToolbarBuilder(modeController, this);
        this.bookmarkEditor = new BookmarkEditor();
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        BookmarksBuilder bookmarksBuilder = new BookmarksBuilder();
        readManager.addElementHandler("bookmarks", (IElementHandler)bookmarksBuilder);
        readManager.addElementHandler("bookmark", (IElementHandler)bookmarksBuilder);
        writeManager.addExtensionElementWriter(MapBookmarks.class, (IExtensionElementWriter)bookmarksBuilder);
        modeController.addAction((AFreeplaneAction)new BookmarkNodeAction(modeController, this));
        modeController.addAction((AFreeplaneAction)new FocusBookmarkToolbarAction());
        ((IconController)modeController.getExtension(IconController.class)).addStateIconProvider(new IStateIconProvider(){

            public UIIcon getStateIcon(NodeModel node) {
                boolean showIcon = ResourceController.getResourceController().getBooleanProperty(BookmarksController.SHOW_BOOKMARK_ICONS);
                if (!showIcon) {
                    return null;
                }
                NodeBookmark bookmark = BookmarksController.this.getBookmarks(node.getMap()).getBookmark(node.getID());
                return bookmark == null ? null : (bookmark.opensAsRoot() ? bookmarkAsRootIcon : bookmarkIcon);
            }

            public boolean mustIncludeInIconRegistry() {
                return true;
            }
        });
        modeController.getMapController().addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                MapBookmarks bookmarks = (MapBookmarks)node.getMap().getExtension(MapBookmarks.class);
                if (bookmarks != null) {
                    bookmarks.onSelect(node);
                }
            }
        });
    }

    public void addBookmark(NodeModel node, NodeBookmarkDescriptor descriptor) {
        MapModel map = node.getMap();
        this.getBookmarks(map).add(node.createID(), descriptor);
        this.fireBookmarksChanged(map);
        this.fireBookmarkChanged(node);
    }

    private void addBookmarkAtPosition(NodeModel node, NodeBookmarkDescriptor descriptor, int position) {
        MapModel map = node.getMap();
        this.getBookmarks(map).addAtPosition(node.createID(), descriptor, position);
        this.fireBookmarksChanged(map);
        this.fireBookmarkChanged(node);
    }

    public void removeBookmark(NodeModel node) {
        MapModel map = node.getMap();
        if (this.getBookmarks(map).remove(node.getID())) {
            this.fireBookmarksChanged(map);
            this.fireBookmarkChanged(node);
        }
    }

    public void removeAllBookmarks(MapModel map) {
        MapBookmarks bookmarks = this.getBookmarks(map);
        List<String> nodeIDs = bookmarks.getNodeIDs();
        if (bookmarks.clear()) {
            this.fireBookmarksChanged(map);
            nodeIDs.stream().map(arg_0 -> ((MapModel)map).getNodeForID(arg_0)).forEach(this::fireBookmarkChanged);
        }
    }

    public void moveBookmark(NodeModel node, int index) {
        MapModel map = node.getMap();
        if (this.getBookmarks(map).move(node.getID(), index)) {
            this.fireBookmarksChanged(map);
        }
    }

    private void fireBookmarksChanged(MapModel map) {
        this.modeController.getMapController().fireMapChanged(new MapChangeEvent((Object)this, map, MapBookmarks.class, null, null));
    }

    private void fireBookmarkChanged(NodeModel node) {
        this.modeController.getMapController().nodeRefresh(new NodeChangeEvent(node, NodeBookmark.class, null, null, false, false));
    }

    public MapBookmarks getBookmarks(MapModel map) {
        return MapBookmarks.of(map);
    }

    public void updateBookmarksToolbar(BookmarkToolbar toolbar, MapModel map) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        this.toolbarBuilder.updateBookmarksToolbar(toolbar, map, selection);
    }

    public boolean createBookmarkFromNode(NodeModel draggedNode, MapModel map, int insertionIndex) {
        if (draggedNode == null) {
            return false;
        }
        NodeBookmark existingBookmark = this.getBookmarks(map).getBookmark(draggedNode.getID());
        if (existingBookmark != null) {
            this.moveExistingBookmarkToPosition(existingBookmark, insertionIndex, map);
        } else {
            this.createNewBookmarkAtPosition(draggedNode, insertionIndex);
        }
        return true;
    }

    private void moveExistingBookmarkToPosition(NodeBookmark existingBookmark, int insertionIndex, MapModel map) {
        List<NodeBookmark> currentBookmarks = this.getBookmarks(map).getBookmarks();
        int currentPosition = this.findBookmarkPosition(currentBookmarks, existingBookmark);
        if (currentPosition != -1 && currentPosition < insertionIndex) {
            --insertionIndex;
        }
        this.moveBookmark(existingBookmark.getNode(), insertionIndex);
    }

    private void createNewBookmarkAtPosition(NodeModel draggedNode, int insertionIndex) {
        String bookmarkName = this.suggestBookmarkNameFromText(draggedNode);
        NodeBookmarkDescriptor descriptor = new NodeBookmarkDescriptor(bookmarkName, false);
        this.addBookmarkAtPosition(draggedNode, descriptor, insertionIndex);
    }

    String suggestBookmarkNameFromText(NodeModel node) {
        String shortText = ((TextController)this.modeController.getExtension(TextController.class)).getShortPlainText(node, 20, "");
        String plainText = shortText.replaceAll("\\s+\\n", " ");
        String normalizedText = CJKNormalizer.removeSpacesBetweenCJKCharacters((String)plainText);
        return normalizedText.isEmpty() ? "Bookmark" : normalizedText;
    }

    public int findBookmarkPosition(List<NodeBookmark> bookmarks, NodeBookmark target) {
        for (int i = 0; i < bookmarks.size(); ++i) {
            if (!bookmarks.get(i).getNode().getID().equals(target.getNode().getID())) continue;
            return i;
        }
        return -1;
    }

    public void editBookmarksForSelection(IMapSelection selection) {
        String suggestedBookmarkName;
        MapBookmarks bookmarks = this.getBookmarks(selection.getSelected().getMap());
        BookmarkEditor.BookmarkSelectionResult result = this.bookmarkEditor.editBookmarksForSelection(selection, bookmarks, suggestedBookmarkName = selection.size() == 1 ? this.suggestBookmarkNameFromText(selection.getSelected()) : "");
        if (result == null || result.getAction() == BookmarkEditor.BookmarkSelectionResult.Action.CANCEL) {
            return;
        }
        if (result.getAction() == BookmarkEditor.BookmarkSelectionResult.Action.DELETE_BOOKMARKS) {
            for (NodeModel node : selection.getOrderedSelection()) {
                this.removeBookmark(node);
            }
        } else if (result.getAction() == BookmarkEditor.BookmarkSelectionResult.Action.ADD_BOOKMARKS) {
            if (selection.size() == 1) {
                this.addSingleBookmark(selection.getSelected(), result);
            } else {
                this.addMultipleBookmarks(selection, result);
            }
        }
    }

    private void addSingleBookmark(NodeModel node, BookmarkEditor.BookmarkSelectionResult result) {
        NodeBookmarkDescriptor descriptor = new NodeBookmarkDescriptor(result.getBookmarkName(), result.opensAsRoot());
        this.addBookmark(node, descriptor);
    }

    private void addMultipleBookmarks(IMapSelection selection, BookmarkEditor.BookmarkSelectionResult result) {
        MapBookmarks bookmarks = this.getBookmarks(selection.getSelected().getMap());
        for (NodeModel node : selection.getOrderedSelection()) {
            String bookmarkName = this.getBookmarkName(node, bookmarks, result.shouldOverwriteNames());
            boolean opensAsRoot = node.isRoot() || result.opensAsRoot();
            NodeBookmarkDescriptor descriptor = new NodeBookmarkDescriptor(bookmarkName, opensAsRoot);
            this.addBookmark(node, descriptor);
        }
    }

    private String getBookmarkName(NodeModel node, MapBookmarks bookmarks, boolean forceOverwrite) {
        NodeBookmark existing = bookmarks.getBookmark(node.getID());
        if (forceOverwrite || existing == null) {
            return this.suggestBookmarkNameFromText(node);
        }
        return existing.getDescriptor().getName();
    }

    public void addNewNode(NodeModel parent) {
        NodeBookmarkDescriptor result = this.bookmarkEditor.showAddNewNodeDialog();
        if (result != null) {
            MMapController mapController = (MMapController)this.modeController.getMapController();
            NodeModel branchNode = mapController.addNewNode(parent, parent.getChildCount(), node -> node.setText(result.getName()));
            this.addBookmark(branchNode, result);
        }
    }

    public void deleteNode(NodeModel node) {
        MMapController mapController = (MMapController)this.modeController.getMapController();
        mapController.deleteNode(node);
    }
}

