/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg.font;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.svg.font.FOPFontFamilyResolver;
import org.apache.fop.svg.font.FOPGVTFontFamily;

public class FOPFontFamilyResolverImpl
implements FOPFontFamilyResolver {
    private final FontInfo fontInfo;

    public FOPFontFamilyResolverImpl(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    @Override
    public FOPGVTFontFamily resolve(String familyName) {
        return this.resolve(familyName, new GVTFontFace(familyName));
    }

    public FOPGVTFontFamily resolve(String familyName, FontFace fontFace) {
        return this.resolve(familyName, (GVTFontFace)FontFace.createFontFace((String)familyName, (FontFace)fontFace));
    }

    private FOPGVTFontFamily resolve(String familyName, GVTFontFace fontFace) {
        FOPGVTFontFamily gvtFontFamily = null;
        FontTriplet triplet = this.fontInfo.fontLookup(familyName, "normal", 400);
        if (this.fontInfo.hasFont(familyName, "normal", 400)) {
            gvtFontFamily = new FOPGVTFontFamily(this.fontInfo, familyName, triplet, fontFace);
        }
        return gvtFontFamily;
    }

    public GVTFontFamily loadFont(InputStream in, FontFace fontFace) throws Exception {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public FOPGVTFontFamily getDefault() {
        return this.resolve("any");
    }

    @Override
    public FOPGVTFontFamily getFamilyThatCanDisplay(char c) {
        Map<String, Typeface> fonts = this.fontInfo.getFonts();
        for (Typeface font : fonts.values()) {
            if (!font.hasChar(c)) continue;
            Set<String> familyNames = font.getFamilyNames();
            String fontFamily = font.getFontName();
            if (!familyNames.isEmpty()) {
                fontFamily = familyNames.iterator().next();
            }
            return new FOPGVTFontFamily(this.fontInfo, fontFamily, new FontTriplet(fontFamily, "normal", 400), new GVTFontFace(fontFamily));
        }
        return null;
    }
}

