/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.Arrays;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.util.CharUtilities;

public class TextArea
extends AbstractTextArea {
    private static final long serialVersionUID = 7315900267242540809L;
    private boolean isHyphenated;

    public TextArea() {
    }

    public TextArea(int stretch, int shrink, int adj) {
        super(stretch, shrink, adj);
    }

    public void removeText() {
        this.inlines.clear();
    }

    public void addWord(String word, int offset) {
        this.addWord(word, 0, null, null, null, offset);
    }

    public void addWord(String word, int offset, int level) {
        this.addWord(word, 0, null, this.makeLevels(level, word.length()), null, offset);
    }

    public void addWord(String word, int ipd, int[] letterAdjust, int[] levels, int[][] gposAdjustments, int blockProgressionOffset, boolean nextIsSpace) {
        int minWordLevel = TextArea.findMinLevel(levels, this.getBidiLevel());
        WordArea wordArea = new WordArea(blockProgressionOffset, minWordLevel, word, letterAdjust, levels, gposAdjustments, false, nextIsSpace);
        wordArea.setIPD(ipd);
        wordArea.setChangeBarList(this.getChangeBarList());
        this.addChildArea(wordArea);
        wordArea.setParentArea(this);
        this.updateLevel(minWordLevel);
    }

    public void addWord(String word, int ipd, int[] letterAdjust, int[] levels, int[][] gposAdjustments, int blockProgressionOffset) {
        this.addWord(word, ipd, letterAdjust, levels, gposAdjustments, blockProgressionOffset, false);
    }

    public void addSpace(char space, int ipd, boolean adjustable, int blockProgressionOffset, int level) {
        SpaceArea spaceArea = new SpaceArea(blockProgressionOffset, level, space, adjustable);
        spaceArea.setIPD(ipd);
        spaceArea.setChangeBarList(this.getChangeBarList());
        this.addChildArea(spaceArea);
        spaceArea.setParentArea(this);
        this.updateLevel(level);
    }

    public void setHyphenated() {
        this.isHyphenated = true;
    }

    public boolean isHyphenated() {
        return this.isHyphenated;
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        for (InlineArea inline : this.inlines) {
            if (inline instanceof WordArea) {
                text.append(((WordArea)inline).getWord());
                continue;
            }
            assert (inline instanceof SpaceArea);
            text.append(((SpaceArea)inline).getSpace());
        }
        return text.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" {text=\"");
        sb.append(CharUtilities.toNCRefs(this.getText()));
        sb.append("\"");
        sb.append("}");
        return sb.toString();
    }

    public void updateLevel(int newLevel) {
        if (newLevel >= 0) {
            int curLevel = this.getBidiLevel();
            if (curLevel >= 0) {
                if (newLevel < curLevel) {
                    this.setBidiLevel(newLevel);
                }
            } else {
                this.setBidiLevel(newLevel);
            }
        }
    }

    private static int findMinLevel(int[] levels, int defaultLevel) {
        if (levels != null) {
            int lMin = Integer.MAX_VALUE;
            for (int l : levels) {
                if (l < 0 || l >= lMin) continue;
                lMin = l;
            }
            if (lMin == Integer.MAX_VALUE) {
                return -1;
            }
            return lMin;
        }
        return defaultLevel;
    }

    private int[] makeLevels(int level, int count) {
        if (level >= 0) {
            int[] levels = new int[count];
            Arrays.fill(levels, level);
            return levels;
        }
        return null;
    }

    @Override
    public int getEffectiveIPD() {
        return this.getIPD();
    }
}

