import { diagnosicSource, formatError } from "../error.js";
function convertDiagnostic(document, source) {
    return {
        range: {
            start: document.positionAt(source.start),
            end: document.positionAt(source.end),
        },
        severity: source.category,
        code: formatError(source.code),
        source: diagnosicSource,
        message: source.message,
    };
}
export function validateDocument(doc, sourceFile) {
    const diagnostics = sourceFile.diagnostics;
    if (!diagnostics || diagnostics.length <= 0)
        return [];
    return diagnostics.map(d => convertDiagnostic(doc, d));
}
//# sourceMappingURL=validation.js.map