/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model.data;

import java.lang.reflect.Array;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.hana.model.data.HANAVectorValueHandler;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class HANAHalfVectorValueHandler
extends HANAVectorValueHandler {
    private static final Log log = Log.getLog(HANAVectorValueHandler.class);
    public static final HANAHalfVectorValueHandler INSTANCE = new HANAHalfVectorValueHandler();

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object != null && object instanceof java.sql.Array) {
            java.sql.Array array = (java.sql.Array)object;
            if (type.getTypeName().equals("HALF_VECTOR")) {
                try {
                    JDBCSession jdbcSession = (JDBCSession)session;
                    DBRProgressMonitor monitor = jdbcSession.getProgressMonitor();
                    JDBCDataSource dataSource = jdbcSession.getDataSource();
                    String baseTypeName = "REAL";
                    DBSDataType elementType = null;
                    try {
                        elementType = dataSource.resolveDataType(monitor, baseTypeName);
                    }
                    catch (DBException e) {
                        throw new DBCException("Error resolving data type", (Throwable)e);
                    }
                    DBDValueHandler elementValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)elementType);
                    Object arrObject = array.getArray();
                    int arrLength = Array.getLength(arrObject);
                    if (arrLength == 0) {
                        throw new DBCException("Non-NULL HALF_VECTOR cannot have 0 dimension");
                    }
                    Object[] contents = new Object[arrLength];
                    int i = 0;
                    while (i < arrLength) {
                        Object item = Array.get(arrObject, i);
                        if (item == null) {
                            throw new DBCException("HALF_VECTOR cannot have NULL element");
                        }
                        contents[i] = elementValueHandler.getValueFromObject((DBCSession)jdbcSession, (DBSTypedObject)elementType, item, false, true);
                        ++i;
                    }
                    return new JDBCCollection(monitor, elementType, elementValueHandler, contents);
                }
                catch (SQLException e) {
                    log.warn((Object)"Cannot display HALF_VECTOR, using default handling", (Throwable)e);
                }
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    @Override
    protected void bindVectorParameter(@NotNull JDBCPreparedStatement statement, int paramIndex, @NotNull JDBCCollection collection) throws DBCException, SQLException {
        if (collection.getComponentType().getTypeID() != 7) {
            throw new DBCException("Only REAL numbers are allowed in HALF_VECTOR as ARRAY");
        }
        float[] nvals = new float[collection.size()];
        int i = 0;
        while (i < nvals.length) {
            Float val = (Float)collection.get(i);
            if (val == null) {
                throw new DBCException("NULL elements are not allowed in HALF_VECTOR");
            }
            nvals[i] = val.floatValue();
            ++i;
        }
        statement.setObject(paramIndex, (Object)nvals);
    }
}

