﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/xray/XRayRequest.h>
#include <aws/xray/XRay_EXPORTS.h>

#include <utility>

namespace Aws {
namespace XRay {
namespace Model {

/**
 */
class DeleteSamplingRuleRequest : public XRayRequest {
 public:
  AWS_XRAY_API DeleteSamplingRuleRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteSamplingRule"; }

  AWS_XRAY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the sampling rule. Specify a rule by either name or ARN, but not
   * both.</p>
   */
  inline const Aws::String& GetRuleName() const { return m_ruleName; }
  inline bool RuleNameHasBeenSet() const { return m_ruleNameHasBeenSet; }
  template <typename RuleNameT = Aws::String>
  void SetRuleName(RuleNameT&& value) {
    m_ruleNameHasBeenSet = true;
    m_ruleName = std::forward<RuleNameT>(value);
  }
  template <typename RuleNameT = Aws::String>
  DeleteSamplingRuleRequest& WithRuleName(RuleNameT&& value) {
    SetRuleName(std::forward<RuleNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the sampling rule. Specify a rule by either name or ARN, but not
   * both.</p>
   */
  inline const Aws::String& GetRuleARN() const { return m_ruleARN; }
  inline bool RuleARNHasBeenSet() const { return m_ruleARNHasBeenSet; }
  template <typename RuleARNT = Aws::String>
  void SetRuleARN(RuleARNT&& value) {
    m_ruleARNHasBeenSet = true;
    m_ruleARN = std::forward<RuleARNT>(value);
  }
  template <typename RuleARNT = Aws::String>
  DeleteSamplingRuleRequest& WithRuleARN(RuleARNT&& value) {
    SetRuleARN(std::forward<RuleARNT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_ruleName;

  Aws::String m_ruleARN;
  bool m_ruleNameHasBeenSet = false;
  bool m_ruleARNHasBeenSet = false;
};

}  // namespace Model
}  // namespace XRay
}  // namespace Aws
