﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>
#include <aws/workspaces-web/model/TrustStore.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {
class GetTrustStoreResult {
 public:
  AWS_WORKSPACESWEB_API GetTrustStoreResult() = default;
  AWS_WORKSPACESWEB_API GetTrustStoreResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESWEB_API GetTrustStoreResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The trust store.</p>
   */
  inline const TrustStore& GetTrustStore() const { return m_trustStore; }
  template <typename TrustStoreT = TrustStore>
  void SetTrustStore(TrustStoreT&& value) {
    m_trustStoreHasBeenSet = true;
    m_trustStore = std::forward<TrustStoreT>(value);
  }
  template <typename TrustStoreT = TrustStore>
  GetTrustStoreResult& WithTrustStore(TrustStoreT&& value) {
    SetTrustStore(std::forward<TrustStoreT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetTrustStoreResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  TrustStore m_trustStore;

  Aws::String m_requestId;
  bool m_trustStoreHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
