﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/Milestone.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {
/**
 * <p>Output of a get milestone call.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestoneOutput">AWS
 * API Reference</a></p>
 */
class GetMilestoneResult {
 public:
  AWS_WELLARCHITECTED_API GetMilestoneResult() = default;
  AWS_WELLARCHITECTED_API GetMilestoneResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WELLARCHITECTED_API GetMilestoneResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Aws::String& GetWorkloadId() const { return m_workloadId; }
  template <typename WorkloadIdT = Aws::String>
  void SetWorkloadId(WorkloadIdT&& value) {
    m_workloadIdHasBeenSet = true;
    m_workloadId = std::forward<WorkloadIdT>(value);
  }
  template <typename WorkloadIdT = Aws::String>
  GetMilestoneResult& WithWorkloadId(WorkloadIdT&& value) {
    SetWorkloadId(std::forward<WorkloadIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Milestone& GetMilestone() const { return m_milestone; }
  template <typename MilestoneT = Milestone>
  void SetMilestone(MilestoneT&& value) {
    m_milestoneHasBeenSet = true;
    m_milestone = std::forward<MilestoneT>(value);
  }
  template <typename MilestoneT = Milestone>
  GetMilestoneResult& WithMilestone(MilestoneT&& value) {
    SetMilestone(std::forward<MilestoneT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetMilestoneResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_workloadId;

  Milestone m_milestone;

  Aws::String m_requestId;
  bool m_workloadIdHasBeenSet = false;
  bool m_milestoneHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
