﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/wafv2/WAFV2Request.h>
#include <aws/wafv2/WAFV2_EXPORTS.h>
#include <aws/wafv2/model/Regex.h>
#include <aws/wafv2/model/Scope.h>

#include <utility>

namespace Aws {
namespace WAFV2 {
namespace Model {

/**
 */
class UpdateRegexPatternSetRequest : public WAFV2Request {
 public:
  AWS_WAFV2_API UpdateRegexPatternSetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateRegexPatternSet"; }

  AWS_WAFV2_API Aws::String SerializePayload() const override;

  AWS_WAFV2_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the set. You cannot change the name after you create the set.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateRegexPatternSetRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether this is for a global resource type, such as a Amazon
   * CloudFront distribution. For an Amplify application, use
   * <code>CLOUDFRONT</code>.</p> <p>To work with CloudFront, you must also specify
   * the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the
   * Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT
   * --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use
   * the Region endpoint us-east-1. </p> </li> </ul>
   */
  inline Scope GetScope() const { return m_scope; }
  inline bool ScopeHasBeenSet() const { return m_scopeHasBeenSet; }
  inline void SetScope(Scope value) {
    m_scopeHasBeenSet = true;
    m_scope = value;
  }
  inline UpdateRegexPatternSetRequest& WithScope(Scope value) {
    SetScope(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier for the set. This ID is returned in the responses to
   * create and list commands. You provide it to operations like update and
   * delete.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  UpdateRegexPatternSetRequest& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the set that helps with identification. </p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  UpdateRegexPatternSetRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p/>
   */
  inline const Aws::Vector<Regex>& GetRegularExpressionList() const { return m_regularExpressionList; }
  inline bool RegularExpressionListHasBeenSet() const { return m_regularExpressionListHasBeenSet; }
  template <typename RegularExpressionListT = Aws::Vector<Regex>>
  void SetRegularExpressionList(RegularExpressionListT&& value) {
    m_regularExpressionListHasBeenSet = true;
    m_regularExpressionList = std::forward<RegularExpressionListT>(value);
  }
  template <typename RegularExpressionListT = Aws::Vector<Regex>>
  UpdateRegexPatternSetRequest& WithRegularExpressionList(RegularExpressionListT&& value) {
    SetRegularExpressionList(std::forward<RegularExpressionListT>(value));
    return *this;
  }
  template <typename RegularExpressionListT = Regex>
  UpdateRegexPatternSetRequest& AddRegularExpressionList(RegularExpressionListT&& value) {
    m_regularExpressionListHasBeenSet = true;
    m_regularExpressionList.emplace_back(std::forward<RegularExpressionListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token used for optimistic locking. WAF returns a token to your
   * <code>get</code> and <code>list</code> requests, to mark the state of the entity
   * at the time of the request. To make changes to the entity associated with the
   * token, you provide the token to operations like <code>update</code> and
   * <code>delete</code>. WAF uses the token to ensure that no changes have been made
   * to the entity since you last retrieved it. If a change has been made, the update
   * fails with a <code>WAFOptimisticLockException</code>. If this happens, perform
   * another <code>get</code>, and use the new token returned by that operation. </p>
   */
  inline const Aws::String& GetLockToken() const { return m_lockToken; }
  inline bool LockTokenHasBeenSet() const { return m_lockTokenHasBeenSet; }
  template <typename LockTokenT = Aws::String>
  void SetLockToken(LockTokenT&& value) {
    m_lockTokenHasBeenSet = true;
    m_lockToken = std::forward<LockTokenT>(value);
  }
  template <typename LockTokenT = Aws::String>
  UpdateRegexPatternSetRequest& WithLockToken(LockTokenT&& value) {
    SetLockToken(std::forward<LockTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Scope m_scope{Scope::NOT_SET};

  Aws::String m_id;

  Aws::String m_description;

  Aws::Vector<Regex> m_regularExpressionList;

  Aws::String m_lockToken;
  bool m_nameHasBeenSet = false;
  bool m_scopeHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_regularExpressionListHasBeenSet = false;
  bool m_lockTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFV2
}  // namespace Aws
