﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wafv2/WAFV2_EXPORTS.h>

namespace Aws {
namespace WAFV2 {
namespace Model {
enum class ResourceType {
  NOT_SET,
  APPLICATION_LOAD_BALANCER,
  API_GATEWAY,
  APPSYNC,
  COGNITO_USER_POOL,
  APP_RUNNER_SERVICE,
  VERIFIED_ACCESS_INSTANCE,
  AMPLIFY
};

namespace ResourceTypeMapper {
AWS_WAFV2_API ResourceType GetResourceTypeForName(const Aws::String& name);

AWS_WAFV2_API Aws::String GetNameForResourceType(ResourceType value);
}  // namespace ResourceTypeMapper
}  // namespace Model
}  // namespace WAFV2
}  // namespace Aws
