﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/timestream-query/TimestreamQuery_EXPORTS.h>
#include <aws/timestream-query/model/DimensionValueType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace TimestreamQuery {
namespace Model {

/**
 * <p>This type is used to map column(s) from the query result to a dimension in
 * the destination table.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DimensionMapping">AWS
 * API Reference</a></p>
 */
class DimensionMapping {
 public:
  AWS_TIMESTREAMQUERY_API DimensionMapping() = default;
  AWS_TIMESTREAMQUERY_API DimensionMapping(Aws::Utils::Json::JsonView jsonValue);
  AWS_TIMESTREAMQUERY_API DimensionMapping& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_TIMESTREAMQUERY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Column name from query result.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DimensionMapping& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Type for the dimension. </p>
   */
  inline DimensionValueType GetDimensionValueType() const { return m_dimensionValueType; }
  inline bool DimensionValueTypeHasBeenSet() const { return m_dimensionValueTypeHasBeenSet; }
  inline void SetDimensionValueType(DimensionValueType value) {
    m_dimensionValueTypeHasBeenSet = true;
    m_dimensionValueType = value;
  }
  inline DimensionMapping& WithDimensionValueType(DimensionValueType value) {
    SetDimensionValueType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  DimensionValueType m_dimensionValueType{DimensionValueType::NOT_SET};
  bool m_nameHasBeenSet = false;
  bool m_dimensionValueTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace TimestreamQuery
}  // namespace Aws
