﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/schemas/Schemas_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Schemas {
namespace Model {

/**
 * <p>A summary of schema details.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SchemaSummary">AWS
 * API Reference</a></p>
 */
class SchemaSummary {
 public:
  AWS_SCHEMAS_API SchemaSummary() = default;
  AWS_SCHEMAS_API SchemaSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_SCHEMAS_API SchemaSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SCHEMAS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The date and time that schema was modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModified() const { return m_lastModified; }
  inline bool LastModifiedHasBeenSet() const { return m_lastModifiedHasBeenSet; }
  template <typename LastModifiedT = Aws::Utils::DateTime>
  void SetLastModified(LastModifiedT&& value) {
    m_lastModifiedHasBeenSet = true;
    m_lastModified = std::forward<LastModifiedT>(value);
  }
  template <typename LastModifiedT = Aws::Utils::DateTime>
  SchemaSummary& WithLastModified(LastModifiedT&& value) {
    SetLastModified(std::forward<LastModifiedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the schema.</p>
   */
  inline const Aws::String& GetSchemaArn() const { return m_schemaArn; }
  inline bool SchemaArnHasBeenSet() const { return m_schemaArnHasBeenSet; }
  template <typename SchemaArnT = Aws::String>
  void SetSchemaArn(SchemaArnT&& value) {
    m_schemaArnHasBeenSet = true;
    m_schemaArn = std::forward<SchemaArnT>(value);
  }
  template <typename SchemaArnT = Aws::String>
  SchemaSummary& WithSchemaArn(SchemaArnT&& value) {
    SetSchemaArn(std::forward<SchemaArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the schema.</p>
   */
  inline const Aws::String& GetSchemaName() const { return m_schemaName; }
  inline bool SchemaNameHasBeenSet() const { return m_schemaNameHasBeenSet; }
  template <typename SchemaNameT = Aws::String>
  void SetSchemaName(SchemaNameT&& value) {
    m_schemaNameHasBeenSet = true;
    m_schemaName = std::forward<SchemaNameT>(value);
  }
  template <typename SchemaNameT = Aws::String>
  SchemaSummary& WithSchemaName(SchemaNameT&& value) {
    SetSchemaName(std::forward<SchemaNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags associated with the schema.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  SchemaSummary& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  SchemaSummary& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of versions available for the schema.</p>
   */
  inline long long GetVersionCount() const { return m_versionCount; }
  inline bool VersionCountHasBeenSet() const { return m_versionCountHasBeenSet; }
  inline void SetVersionCount(long long value) {
    m_versionCountHasBeenSet = true;
    m_versionCount = value;
  }
  inline SchemaSummary& WithVersionCount(long long value) {
    SetVersionCount(value);
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_lastModified{};

  Aws::String m_schemaArn;

  Aws::String m_schemaName;

  Aws::Map<Aws::String, Aws::String> m_tags;

  long long m_versionCount{0};
  bool m_lastModifiedHasBeenSet = false;
  bool m_schemaArnHasBeenSet = false;
  bool m_schemaNameHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_versionCountHasBeenSet = false;
};

}  // namespace Model
}  // namespace Schemas
}  // namespace Aws
