﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/LineageType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>A lineage entity connected to the starting entity(ies).</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Vertex">AWS
 * API Reference</a></p>
 */
class Vertex {
 public:
  AWS_SAGEMAKER_API Vertex() = default;
  AWS_SAGEMAKER_API Vertex(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Vertex& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the lineage entity resource.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  Vertex& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the lineage entity resource. For example: <code>DataSet</code>,
   * <code>Model</code>, <code>Endpoint</code>, etc...</p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  Vertex& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of resource of the lineage entity.</p>
   */
  inline LineageType GetLineageType() const { return m_lineageType; }
  inline bool LineageTypeHasBeenSet() const { return m_lineageTypeHasBeenSet; }
  inline void SetLineageType(LineageType value) {
    m_lineageTypeHasBeenSet = true;
    m_lineageType = value;
  }
  inline Vertex& WithLineageType(LineageType value) {
    SetLineageType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_type;

  LineageType m_lineageType{LineageType::NOT_SET};
  bool m_arnHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_lineageTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
