﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/TopicSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {
class SearchTopicsResult {
 public:
  AWS_QUICKSIGHT_API SearchTopicsResult() = default;
  AWS_QUICKSIGHT_API SearchTopicsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_QUICKSIGHT_API SearchTopicsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of topic summaries that is returned by the search topic request.</p>
   */
  inline const Aws::Vector<TopicSummary>& GetTopicSummaryList() const { return m_topicSummaryList; }
  template <typename TopicSummaryListT = Aws::Vector<TopicSummary>>
  void SetTopicSummaryList(TopicSummaryListT&& value) {
    m_topicSummaryListHasBeenSet = true;
    m_topicSummaryList = std::forward<TopicSummaryListT>(value);
  }
  template <typename TopicSummaryListT = Aws::Vector<TopicSummary>>
  SearchTopicsResult& WithTopicSummaryList(TopicSummaryListT&& value) {
    SetTopicSummaryList(std::forward<TopicSummaryListT>(value));
    return *this;
  }
  template <typename TopicSummaryListT = TopicSummary>
  SearchTopicsResult& AddTopicSummaryList(TopicSummaryListT&& value) {
    m_topicSummaryListHasBeenSet = true;
    m_topicSummaryList.emplace_back(std::forward<TopicSummaryListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the next set of results, or null if there are no more
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  SearchTopicsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The HTTP status of the request.</p>
   */
  inline int GetStatus() const { return m_status; }
  inline void SetStatus(int value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline SearchTopicsResult& WithStatus(int value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  SearchTopicsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TopicSummary> m_topicSummaryList;

  Aws::String m_nextToken;

  int m_status{0};

  Aws::String m_requestId;
  bool m_topicSummaryListHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
