﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/qbusiness/QBusiness_EXPORTS.h>
#include <aws/qbusiness/model/Conversation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace QBusiness {
namespace Model {
class ListConversationsResult {
 public:
  AWS_QBUSINESS_API ListConversationsResult() = default;
  AWS_QBUSINESS_API ListConversationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_QBUSINESS_API ListConversationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>If the response is truncated, Amazon Q Business returns this token, which you
   * can use in a later request to list the next set of messages.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListConversationsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of summary information on the configuration of one or more Amazon Q
   * Business web experiences.</p>
   */
  inline const Aws::Vector<Conversation>& GetConversations() const { return m_conversations; }
  template <typename ConversationsT = Aws::Vector<Conversation>>
  void SetConversations(ConversationsT&& value) {
    m_conversationsHasBeenSet = true;
    m_conversations = std::forward<ConversationsT>(value);
  }
  template <typename ConversationsT = Aws::Vector<Conversation>>
  ListConversationsResult& WithConversations(ConversationsT&& value) {
    SetConversations(std::forward<ConversationsT>(value));
    return *this;
  }
  template <typename ConversationsT = Conversation>
  ListConversationsResult& AddConversations(ConversationsT&& value) {
    m_conversationsHasBeenSet = true;
    m_conversations.emplace_back(std::forward<ConversationsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListConversationsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<Conversation> m_conversations;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_conversationsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QBusiness
}  // namespace Aws
